/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import org.dmg.pmml.DataType;
import org.dmg.pmml.SimplePredicate;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSimplePredicateFactory {
    static final String KIE_PMML_SIMPLE_PREDICATE_EVALUATE_METHOD_TEMPLATE_JAVA = "KiePMMLSimplePredicateEvaluateMethodTemplate.tmpl";
    static final String KIE_PMML_SIMPLE_PREDICATE_EVALUATE_METHOD_TEMPLATE = "KiePMMLSimplePredicateEvaluateMethodTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLSimplePredicateFactory.class.getName());

    private KiePMMLSimplePredicateFactory() {
    }

    public static BlockStmt getSimplePredicateBody(SimplePredicate predicate, DataType dataType) {
        OPERATOR kiePMMLOperator = OPERATOR.byName((String)predicate.getOperator().value());
        Object value = KiePMMLPredicateFactory.getActualValue(predicate.getValue(), dataType);
        try {
            String methodName = kiePMMLOperator.isOnlyNumberOperator() && !(value instanceof Number) ? "evaluateFALSE" : String.format("evaluate%s", kiePMMLOperator.name());
            CompilationUnit templateEvaluate = JavaParserUtils.getFromFileName(KIE_PMML_SIMPLE_PREDICATE_EVALUATE_METHOD_TEMPLATE_JAVA);
            CompilationUnit cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_SIMPLE_PREDICATE_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException("Main class not found"));
            BlockStmt toReturn = (BlockStmt)((MethodDeclaration)evaluateTemplateClass.getMethodsByName(methodName).get(0)).getBody().orElseThrow(() -> new KiePMMLInternalException("Failed to find body for " + kiePMMLOperator));
            CommonCodegenUtils.replaceStringLiteralExpressionInStatement((Statement)toReturn, "avalue", predicate.getField().getValue());
            if (kiePMMLOperator.isValueOperator() && !methodName.equals("evaluateFALSE") && value != null) {
                Object valueExpression = value instanceof String ? new StringLiteralExpr(value.toString()) : new NameExpr(value.toString());
                CommonCodegenUtils.setVariableDeclaratorValue(toReturn, "value", (Expression)valueExpression);
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(e.getMessage());
        }
    }
}

