/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.SimpleSetPredicate;
import org.kie.pmml.api.enums.ARRAY_TYPE;
import org.kie.pmml.api.enums.IN_NOTIN;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSimpleSetPredicateFactory {
    static final String KIE_PMML_SIMPLE_SET_PREDICATE_EVALUATE_METHOD_TEMPLATE_JAVA = "KiePMMLSimpleSetPredicateEvaluateMethodTemplate.tmpl";
    static final String KIE_PMML_SIMPLE_SET_PREDICATE_EVALUATE_METHOD_TEMPLATE = "KiePMMLSimpleSetPredicateEvaluateMethodTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLSimpleSetPredicateFactory.class.getName());

    private KiePMMLSimpleSetPredicateFactory() {
    }

    public static BlockStmt getSimpleSetPredicateBody(SimpleSetPredicate predicate) {
        ARRAY_TYPE arrayType = ARRAY_TYPE.byName((String)predicate.getArray().getType().value());
        IN_NOTIN kiePMMLIN_NOTINT = IN_NOTIN.byName((String)predicate.getBooleanOperator().value());
        String methodName = String.format("evaluate%s", kiePMMLIN_NOTINT.name());
        try {
            CompilationUnit templateEvaluate = JavaParserUtils.getFromFileName(KIE_PMML_SIMPLE_SET_PREDICATE_EVALUATE_METHOD_TEMPLATE_JAVA);
            CompilationUnit cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_SIMPLE_SET_PREDICATE_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException("Main class not found"));
            BlockStmt toReturn = (BlockStmt)((MethodDeclaration)evaluateTemplateClass.getMethodsByName(methodName).get(0)).getBody().orElseThrow(() -> new KiePMMLInternalException("Failed to find body for " + kiePMMLIN_NOTINT));
            String arrayTypeString = arrayType.getClass().getCanonicalName() + "." + arrayType.name();
            CommonCodegenUtils.setVariableDeclaratorValue(toReturn, "arrayType", (Expression)new NameExpr(arrayTypeString));
            List<Object> values = KiePMMLPredicateFactory.getObjectsFromArray(predicate.getArray());
            NodeList valuesExpressions = new NodeList();
            for (Object value : values) {
                if (arrayType == ARRAY_TYPE.STRING) {
                    valuesExpressions.add((Node)new StringLiteralExpr(value.toString()));
                    continue;
                }
                valuesExpressions.add((Node)new NameExpr(value.toString()));
            }
            MethodCallExpr valuesInit = new MethodCallExpr();
            valuesInit.setScope((Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Arrays.class.getName())));
            valuesInit.setName("asList");
            valuesInit.setArguments(valuesExpressions);
            CommonCodegenUtils.setVariableDeclaratorValue(toReturn, "values", (Expression)valuesInit);
            CommonCodegenUtils.replaceStringLiteralExpressionInStatement((Statement)toReturn, "avalue", predicate.getField().getValue());
            return toReturn;
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(e.getMessage());
        }
    }
}

