/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;

public class DefineFunctionUtils {
    private DefineFunctionUtils() {
    }

    static Map<String, MethodDeclaration> getDefineFunctionsMethodMap(List<DefineFunction> defineFunctions) {
        HashMap<String, MethodDeclaration> toReturn = new HashMap<String, MethodDeclaration>();
        defineFunctions.forEach(defineFunction -> toReturn.put(defineFunction.getName(), DefineFunctionUtils.getDefineFunctionMethodDeclaration(defineFunction)));
        return toReturn;
    }

    static MethodDeclaration getDefineFunctionMethodDeclaration(DefineFunction defineFunction) {
        Expression expression = defineFunction.getExpression();
        if (expression != null) {
            return ExpressionFunctionUtils.getExpressionMethodDeclarationWithVariableParameters(defineFunction.getName(), expression, defineFunction.getDataType(), defineFunction.getParameterFields());
        }
        throw new KiePMMLException("Define Function without Expression are not supported, yet");
    }
}

