/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;

public class DerivedFieldFunctionUtils {
    private DerivedFieldFunctionUtils() {
    }

    static Map<String, MethodDeclaration> getDerivedFieldsMethodMap(List<DerivedField> derivedFields, AtomicInteger arityCounter) {
        HashMap<String, MethodDeclaration> toReturn = new HashMap<String, MethodDeclaration>();
        derivedFields.forEach(derivedField -> toReturn.put(derivedField.getName().getValue(), DerivedFieldFunctionUtils.getDerivedFieldMethodDeclaration(derivedField, arityCounter)));
        return toReturn;
    }

    static MethodDeclaration getDerivedFieldMethodDeclaration(DerivedField derivedField, AtomicInteger arityCounter) {
        Expression expression = derivedField.getExpression();
        if (expression != null) {
            String methodName = String.format("%s%s", expression.getClass().getSimpleName(), arityCounter.addAndGet(1));
            return ExpressionFunctionUtils.getExpressionMethodDeclarationWithKiePMMLNameValues(expression, derivedField.getDataType(), methodName);
        }
        throw new KiePMMLException("Derived field without Expression are not supported, yet");
    }
}

