/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.Apply;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLExpressionFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLApplyFactory {
    static final String KIE_PMML_APPLY_TEMPLATE_JAVA = "KiePMMLApplyTemplate.tmpl";
    static final String KIE_PMML_APPLY_TEMPLATE = "KiePMMLApplyTemplate";
    static final String GETKIEPMMLAPPLY = "getKiePMMLApply";
    static final String APPLY = "apply";
    static final ClassOrInterfaceDeclaration APPLY_TEMPLATE;

    private KiePMMLApplyFactory() {
    }

    static BlockStmt getApplyVariableDeclaration(String variableName, Apply apply) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)APPLY_TEMPLATE.getMethodsByName(GETKIEPMMLAPPLY).get(0)).clone();
        BlockStmt applyBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(applyBody, APPLY).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", APPLY, applyBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        int counter = 0;
        NodeList arguments = new NodeList();
        for (org.dmg.pmml.Expression expression : apply.getExpressions()) {
            String nestedVariableName = String.format("%s_%s", variableName, counter);
            arguments.add((Node)new NameExpr(nestedVariableName));
            BlockStmt toAdd = KiePMMLExpressionFactory.getKiePMMLExpression(nestedVariableName, expression);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
            ++counter;
        }
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", APPLY, toReturn)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom("builder", initializer);
        StringLiteralExpr nameExpr = new StringLiteralExpr(variableName);
        StringLiteralExpr functionExpr = new StringLiteralExpr(apply.getFunction());
        builder.setArgument(0, (Expression)nameExpr);
        builder.setArgument(2, (Expression)functionExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withDefaultValue", initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject(apply.getDefaultValue()));
        CommonCodegenUtils.getChainedMethodCallExprFrom("withMapMissingTo", initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject(apply.getMapMissingTo()));
        StringLiteralExpr invalidTreatmentExpr = apply.getInvalidValueTreatment() != null ? new StringLiteralExpr(apply.getInvalidValueTreatment().value()) : new NullLiteralExpr();
        CommonCodegenUtils.getChainedMethodCallExprFrom("withInvalidValueTreatmentMethod", initializer).setArgument(0, (Expression)invalidTreatmentExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("asList", initializer).setArguments(arguments);
        applyBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_APPLY_TEMPLATE_JAVA);
        APPLY_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_APPLY_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLApplyTemplate"));
        ((MethodDeclaration)APPLY_TEMPLATE.getMethodsByName(GETKIEPMMLAPPLY).get(0)).clone();
    }
}

