/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.builders;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;

public class KiePMMLModelCodegenUtils {
    private KiePMMLModelCodegenUtils() {
    }

    public static void init(CompilationDTO<? extends Model> compilationDTO, ClassOrInterfaceDeclaration modelTemplate) {
        NullLiteralExpr miningFunctionExpression;
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        String name = compilationDTO.getModelName();
        String generatedClassName = compilationDTO.getSimpleClassName();
        List miningFields = ModelUtils.convertToKieMiningFieldList((MiningSchema)compilationDTO.getMiningSchema(), (List)compilationDTO.getFields());
        List outputFields = ModelUtils.convertToKieOutputFieldList((Output)compilationDTO.getOutput(), (List)compilationDTO.getFields());
        if (compilationDTO.getMINING_FUNCTION() != null) {
            MINING_FUNCTION miningFunction = compilationDTO.getMINING_FUNCTION();
            miningFunctionExpression = new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name());
        } else {
            miningFunctionExpression = new NullLiteralExpr();
        }
        PMML_MODEL pmmlModelEnum = compilationDTO.getPMML_MODEL();
        NameExpr pmmlMODELExpression = new NameExpr(pmmlModelEnum.getClass().getName() + "." + pmmlModelEnum.name());
        String targetFieldName = compilationDTO.getTargetFieldName();
        Object targetFieldExpression = targetFieldName != null ? new StringLiteralExpr(targetFieldName) : new NullLiteralExpr();
        KiePMMLModelFactoryUtils.setKiePMMLModelConstructor(generatedClassName, constructorDeclaration, name, miningFields, outputFields);
        KiePMMLModelFactoryUtils.addTransformationsInClassOrInterfaceDeclaration(modelTemplate, compilationDTO.getTransformationDictionary(), compilationDTO.getLocalTransformations());
        BlockStmt body = constructorDeclaration.getBody();
        CommonCodegenUtils.setAssignExpressionValue(body, "pmmlMODEL", (Expression)pmmlMODELExpression);
        CommonCodegenUtils.setAssignExpressionValue(body, "miningFunction", (Expression)miningFunctionExpression);
        CommonCodegenUtils.setAssignExpressionValue(body, "targetField", (Expression)targetFieldExpression);
        KiePMMLModelFactoryUtils.addGetCreatedKiePMMLMiningFieldsMethod(modelTemplate, compilationDTO.getMiningSchema().getMiningFields(), compilationDTO.getFields());
        MethodCallExpr getCreatedKiePMMLMiningFieldsExpr = new MethodCallExpr();
        getCreatedKiePMMLMiningFieldsExpr.setScope((Expression)new ThisExpr());
        getCreatedKiePMMLMiningFieldsExpr.setName("getCreatedKiePMMLMiningFields");
        CommonCodegenUtils.setAssignExpressionValue(body, "kiePMMLMiningFields", (Expression)getCreatedKiePMMLMiningFieldsExpr);
        if (compilationDTO.getOutput() != null) {
            KiePMMLModelFactoryUtils.addGetCreatedKiePMMLOutputFieldsMethod(modelTemplate, compilationDTO.getOutput().getOutputFields());
            MethodCallExpr getCreatedKiePMMLOutputFieldsExpr = new MethodCallExpr();
            getCreatedKiePMMLOutputFieldsExpr.setScope((Expression)new ThisExpr());
            getCreatedKiePMMLOutputFieldsExpr.setName("getCreatedKiePMMLOutputFields");
            CommonCodegenUtils.setAssignExpressionValue(body, "kiePMMLOutputFields", (Expression)getCreatedKiePMMLOutputFieldsExpr);
        }
    }
}

