/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.MISSING_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.models.TargetField;
import org.kie.pmml.commons.model.KiePMMLMiningField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.transformations.KiePMMLLocalTransformations;
import org.kie.pmml.commons.transformations.KiePMMLTransformationDictionary;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLLocalTransformationsFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLMiningFieldFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLOutputFieldFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTargetFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTransformationDictionaryFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;

public class KiePMMLModelFactoryUtils {
    public static final String GET_CREATED_MININGFIELDS = "getCreatedMiningFields";
    public static final String GET_CREATED_OUTPUTFIELDS = "getCreatedOutputFields";
    public static final String GET_CREATED_KIEPMMLMININGFIELDS = "getCreatedKiePMMLMiningFields";
    public static final String GET_CREATED_KIEPMMLOUTPUTFIELDS = "getCreatedKiePMMLOutputFields";
    public static final String GET_CREATED_KIEPMMLTARGETS = "getCreatedKiePMMLTargets";
    public static final String GET_CREATED_LOCAL_TRANSFORMATIONS = "getCreatedLocalTransformations";
    public static final String GET_CREATED_TRANSFORMATION_DICTIONARY = "getCreatedTransformationDictionary";

    private KiePMMLModelFactoryUtils() {
    }

    public static void setKiePMMLConstructorSuperNameInvocation(String generatedClassName, ConstructorDeclaration constructorDeclaration, String fileName, String name) {
        constructorDeclaration.setName(generatedClassName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument(superStatement, "fileName", String.format("\"%s\"", fileName));
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument(superStatement, "name", String.format("\"%s\"", name));
    }

    public static void setConstructorSuperNameInvocation(String generatedClassName, ConstructorDeclaration constructorDeclaration, String name) {
        constructorDeclaration.setName(generatedClassName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument(superStatement, "name", String.format("\"%s\"", name));
    }

    public static void setKiePMMLModelConstructor(String generatedClassName, ConstructorDeclaration constructorDeclaration, String fileName, String name, List<MiningField> miningFields, List<OutputField> outputFields, List<TargetField> targetFields) {
        KiePMMLModelFactoryUtils.setKiePMMLConstructorSuperNameInvocation(generatedClassName, constructorDeclaration, fileName, name);
        BlockStmt body = constructorDeclaration.getBody();
        List<ObjectCreationExpr> miningFieldsObjectCreations = KiePMMLModelFactoryUtils.getMiningFieldsObjectCreations(miningFields);
        CommonCodegenUtils.addListPopulationByObjectCreationExpr(miningFieldsObjectCreations, body, "miningFields");
        List<ObjectCreationExpr> outputFieldsObjectCreations = KiePMMLModelFactoryUtils.getOutputFieldsObjectCreations(outputFields);
        CommonCodegenUtils.addListPopulationByObjectCreationExpr(outputFieldsObjectCreations, body, "outputFields");
        List<MethodCallExpr> kiePMMLTargetFieldsObjectCreations = KiePMMLModelFactoryUtils.getKiePMMLTargetFieldsObjectCreations(targetFields);
        CommonCodegenUtils.addListPopulationByMethodCallExpr(kiePMMLTargetFieldsObjectCreations, body, "kiePMMLTargets");
    }

    public static void addGetCreatedKiePMMLMiningFieldsMethod(ClassOrInterfaceDeclaration modelTemplate, List<org.dmg.pmml.MiningField> miningFields, List<Field<?>> fields) {
        MethodDeclaration methodDeclaration = modelTemplate.addMethod(GET_CREATED_KIEPMMLMININGFIELDS, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
        ClassOrInterfaceType returnedType = CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames(List.class.getSimpleName(), Collections.singletonList(KiePMMLMiningField.class.getSimpleName()));
        methodDeclaration.setType((Type)returnedType);
        KiePMMLModelFactoryUtils.commonPopulateGetCreatedKiePMMLMiningFieldsMethod(methodDeclaration, miningFields, fields);
    }

    public static void populateGetCreatedMiningFieldsMethod(ClassOrInterfaceDeclaration modelTemplate, List<MiningField> miningFields) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)modelTemplate.getMethodsByName(GET_CREATED_MININGFIELDS).get(0);
        List<ObjectCreationExpr> miningFieldsObjectCreations = KiePMMLModelFactoryUtils.getMiningFieldsObjectCreations(miningFields);
        CommonCodegenUtils.populateListInListGetter(miningFieldsObjectCreations, methodDeclaration, "toReturn");
    }

    public static void populateGetCreatedOutputFieldsMethod(ClassOrInterfaceDeclaration modelTemplate, List<OutputField> outputFields) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)modelTemplate.getMethodsByName(GET_CREATED_OUTPUTFIELDS).get(0);
        List<ObjectCreationExpr> outputFieldsObjectCreations = KiePMMLModelFactoryUtils.getOutputFieldsObjectCreations(outputFields);
        CommonCodegenUtils.populateListInListGetter(outputFieldsObjectCreations, methodDeclaration, "toReturn");
    }

    public static void populateGetCreatedKiePMMLMiningFieldsMethod(ClassOrInterfaceDeclaration modelTemplate, List<org.dmg.pmml.MiningField> miningFields, List<Field<?>> fields) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)modelTemplate.getMethodsByName(GET_CREATED_KIEPMMLMININGFIELDS).get(0);
        KiePMMLModelFactoryUtils.commonPopulateGetCreatedKiePMMLMiningFieldsMethod(methodDeclaration, miningFields, fields);
    }

    public static void addGetCreatedKiePMMLOutputFieldsMethod(ClassOrInterfaceDeclaration modelTemplate, List<org.dmg.pmml.OutputField> outputFields) {
        MethodDeclaration methodDeclaration = modelTemplate.addMethod(GET_CREATED_KIEPMMLOUTPUTFIELDS, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
        ClassOrInterfaceType returnedType = CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames(List.class.getSimpleName(), Collections.singletonList(KiePMMLOutputField.class.getSimpleName()));
        methodDeclaration.setType((Type)returnedType);
        KiePMMLModelFactoryUtils.commonPopulateGetCreatedKiePMMLOutputFieldsMethod(methodDeclaration, outputFields);
    }

    public static void populateGetCreatedKiePMMLOutputFieldsMethod(ClassOrInterfaceDeclaration modelTemplate, List<org.dmg.pmml.OutputField> outputFields) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)modelTemplate.getMethodsByName(GET_CREATED_KIEPMMLOUTPUTFIELDS).get(0);
        KiePMMLModelFactoryUtils.commonPopulateGetCreatedKiePMMLOutputFieldsMethod(methodDeclaration, outputFields);
    }

    public static void populateGetCreatedKiePMMLTargetsMethod(ClassOrInterfaceDeclaration modelTemplate, List<TargetField> targetFields) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)modelTemplate.getMethodsByName(GET_CREATED_KIEPMMLTARGETS).get(0);
        List<MethodCallExpr> kiePMMLTargetFieldsObjectCreations = KiePMMLModelFactoryUtils.getKiePMMLTargetFieldsObjectCreations(targetFields);
        CommonCodegenUtils.populateListInListGetter(kiePMMLTargetFieldsObjectCreations, methodDeclaration, "toReturn");
    }

    public static void populateGetCreatedTransformationDictionaryMethod(ClassOrInterfaceDeclaration toPopulate, TransformationDictionary transformationDictionary) {
        if (transformationDictionary != null) {
            BlockStmt createTransformationDictionaryBody = KiePMMLTransformationDictionaryFactory.getKiePMMLTransformationDictionaryVariableDeclaration(transformationDictionary);
            createTransformationDictionaryBody.addStatement((Statement)CommonCodegenUtils.getReturnStmt("transformationDictionary"));
            MethodDeclaration methodDeclaration = (MethodDeclaration)toPopulate.getMethodsByName(GET_CREATED_TRANSFORMATION_DICTIONARY).get(0);
            methodDeclaration.setBody(createTransformationDictionaryBody);
        }
    }

    public static void populateGetCreatedLocalTransformationsMethod(ClassOrInterfaceDeclaration toPopulate, LocalTransformations localTransformations) {
        if (localTransformations != null) {
            BlockStmt createLocalTransformationsBody = KiePMMLLocalTransformationsFactory.getKiePMMLLocalTransformationsVariableDeclaration(localTransformations);
            createLocalTransformationsBody.addStatement((Statement)CommonCodegenUtils.getReturnStmt("localTransformations"));
            MethodDeclaration methodDeclaration = (MethodDeclaration)toPopulate.getMethodsByName(GET_CREATED_LOCAL_TRANSFORMATIONS).get(0);
            methodDeclaration.setBody(createLocalTransformationsBody);
        }
    }

    public static void addTransformationsInClassOrInterfaceDeclaration(ClassOrInterfaceDeclaration toPopulate, TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        String createTransformationDictionary = null;
        if (transformationDictionary != null) {
            BlockStmt createTransformationDictionaryBody = KiePMMLTransformationDictionaryFactory.getKiePMMLTransformationDictionaryVariableDeclaration(transformationDictionary);
            createTransformationDictionaryBody.addStatement((Statement)CommonCodegenUtils.getReturnStmt("transformationDictionary"));
            createTransformationDictionary = "createTransformationDictionary";
            MethodDeclaration createTransformationDictionaryMethod = toPopulate.addMethod(createTransformationDictionary, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
            createTransformationDictionaryMethod.setType(KiePMMLTransformationDictionary.class.getName());
            createTransformationDictionaryMethod.setBody(createTransformationDictionaryBody);
        }
        String createLocalTransformations = null;
        if (localTransformations != null) {
            BlockStmt createLocalTransformationsBody = KiePMMLLocalTransformationsFactory.getKiePMMLLocalTransformationsVariableDeclaration(localTransformations);
            createLocalTransformationsBody.addStatement((Statement)CommonCodegenUtils.getReturnStmt("localTransformations"));
            createLocalTransformations = "createLocalTransformations";
            MethodDeclaration createLocalTransformationsMethod = toPopulate.addMethod(createLocalTransformations, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
            createLocalTransformationsMethod.setType(KiePMMLLocalTransformations.class.getName());
            createLocalTransformationsMethod.setBody(createLocalTransformationsBody);
        }
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)toPopulate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", toPopulate.getName())));
        KiePMMLModelFactoryUtils.populateTransformationsInConstructor(constructorDeclaration, createTransformationDictionary, createLocalTransformations);
    }

    public static void init(CompilationDTO<? extends Model> compilationDTO, ClassOrInterfaceDeclaration modelTemplate) {
        NullLiteralExpr miningFunctionExpression;
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        String fileName = compilationDTO.getFileName();
        String name = compilationDTO.getModelName();
        String generatedClassName = compilationDTO.getSimpleClassName();
        List miningFields = compilationDTO.getKieMiningFields();
        List outputFields = compilationDTO.getKieOutputFields();
        List targetFields = compilationDTO.getKieTargetFields();
        if (compilationDTO.getMINING_FUNCTION() != null) {
            MINING_FUNCTION miningFunction = compilationDTO.getMINING_FUNCTION();
            miningFunctionExpression = new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name());
        } else {
            miningFunctionExpression = new NullLiteralExpr();
        }
        PMML_MODEL pmmlModelEnum = compilationDTO.getPMML_MODEL();
        NameExpr pmmlMODELExpression = new NameExpr(pmmlModelEnum.getClass().getName() + "." + pmmlModelEnum.name());
        String targetFieldName = compilationDTO.getTargetFieldName();
        Object targetFieldExpression = targetFieldName != null ? new StringLiteralExpr(targetFieldName) : new NullLiteralExpr();
        KiePMMLModelFactoryUtils.setKiePMMLModelConstructor(generatedClassName, constructorDeclaration, fileName, name, miningFields, outputFields, targetFields);
        KiePMMLModelFactoryUtils.addTransformationsInClassOrInterfaceDeclaration(modelTemplate, compilationDTO.getTransformationDictionary(), compilationDTO.getLocalTransformations());
        BlockStmt body = constructorDeclaration.getBody();
        CommonCodegenUtils.setAssignExpressionValue(body, "pmmlMODEL", (Expression)pmmlMODELExpression);
        CommonCodegenUtils.setAssignExpressionValue(body, "miningFunction", (Expression)miningFunctionExpression);
        CommonCodegenUtils.setAssignExpressionValue(body, "targetField", (Expression)targetFieldExpression);
        KiePMMLModelFactoryUtils.addGetCreatedKiePMMLMiningFieldsMethod(modelTemplate, compilationDTO.getMiningSchema().getMiningFields(), compilationDTO.getFields());
        MethodCallExpr getCreatedKiePMMLMiningFieldsExpr = new MethodCallExpr();
        getCreatedKiePMMLMiningFieldsExpr.setScope((Expression)new ThisExpr());
        getCreatedKiePMMLMiningFieldsExpr.setName(GET_CREATED_KIEPMMLMININGFIELDS);
        CommonCodegenUtils.setAssignExpressionValue(body, "kiePMMLMiningFields", (Expression)getCreatedKiePMMLMiningFieldsExpr);
        if (compilationDTO.getOutput() != null) {
            KiePMMLModelFactoryUtils.addGetCreatedKiePMMLOutputFieldsMethod(modelTemplate, compilationDTO.getOutput().getOutputFields());
            MethodCallExpr getCreatedKiePMMLOutputFieldsExpr = new MethodCallExpr();
            getCreatedKiePMMLOutputFieldsExpr.setScope((Expression)new ThisExpr());
            getCreatedKiePMMLOutputFieldsExpr.setName(GET_CREATED_KIEPMMLOUTPUTFIELDS);
            CommonCodegenUtils.setAssignExpressionValue(body, "kiePMMLOutputFields", (Expression)getCreatedKiePMMLOutputFieldsExpr);
        }
    }

    public static void initStaticGetter(CompilationDTO<? extends Model> compilationDTO, ClassOrInterfaceDeclaration modelTemplate) {
        NullLiteralExpr miningFunctionExpression;
        MethodDeclaration staticGetterMethod = (MethodDeclaration)modelTemplate.getMethodsByName("getModel").get(0);
        BlockStmt staticGetterBody = (BlockStmt)staticGetterMethod.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", staticGetterMethod)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(staticGetterBody, "toReturn").orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", "toReturn", staticGetterBody)));
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", "toReturn", staticGetterBody)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom("builder", initializer);
        String fileName = compilationDTO.getFileName();
        String name = compilationDTO.getModelName();
        if (compilationDTO.getMINING_FUNCTION() != null) {
            MINING_FUNCTION miningFunction = compilationDTO.getMINING_FUNCTION();
            miningFunctionExpression = new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name());
        } else {
            miningFunctionExpression = new NullLiteralExpr();
        }
        builder.setArgument(0, (Expression)new StringLiteralExpr(fileName));
        builder.setArgument(1, (Expression)new StringLiteralExpr(name));
        builder.setArgument(2, (Expression)miningFunctionExpression);
        String targetFieldName = compilationDTO.getTargetFieldName();
        Object targetFieldExpression = targetFieldName != null ? new StringLiteralExpr(targetFieldName) : new NullLiteralExpr();
        CommonCodegenUtils.getChainedMethodCallExprFrom("withTargetField", initializer).setArgument(0, (Expression)targetFieldExpression);
        KiePMMLModelFactoryUtils.populateGetCreatedMiningFieldsMethod(modelTemplate, compilationDTO.getKieMiningFields());
        KiePMMLModelFactoryUtils.populateGetCreatedOutputFieldsMethod(modelTemplate, compilationDTO.getKieOutputFields());
        KiePMMLModelFactoryUtils.populateGetCreatedKiePMMLMiningFieldsMethod(modelTemplate, compilationDTO.getMiningSchema().getMiningFields(), compilationDTO.getFields());
        if (compilationDTO.getOutput() != null) {
            KiePMMLModelFactoryUtils.populateGetCreatedKiePMMLOutputFieldsMethod(modelTemplate, compilationDTO.getOutput().getOutputFields());
        }
        if (compilationDTO.getKieTargetFields() != null) {
            KiePMMLModelFactoryUtils.populateGetCreatedKiePMMLTargetsMethod(modelTemplate, compilationDTO.getKieTargetFields());
        }
        KiePMMLModelFactoryUtils.populateGetCreatedTransformationDictionaryMethod(modelTemplate, compilationDTO.getTransformationDictionary());
        KiePMMLModelFactoryUtils.populateGetCreatedLocalTransformationsMethod(modelTemplate, compilationDTO.getLocalTransformations());
    }

    static List<ObjectCreationExpr> getMiningFieldsObjectCreations(List<MiningField> miningFields) {
        return miningFields.stream().map(miningField -> {
            ObjectCreationExpr toReturn = new ObjectCreationExpr();
            toReturn.setType(MiningField.class.getCanonicalName());
            StringLiteralExpr name = miningField.getName() != null ? new StringLiteralExpr(miningField.getName()) : new NullLiteralExpr();
            FIELD_USAGE_TYPE fieldUsageType = miningField.getUsageType();
            NameExpr usageType = fieldUsageType != null ? new NameExpr(fieldUsageType.getClass().getName() + "." + fieldUsageType.name()) : new NullLiteralExpr();
            OP_TYPE oPT = miningField.getOpType();
            NameExpr opType = oPT != null ? new NameExpr(oPT.getClass().getName() + "." + oPT.name()) : new NullLiteralExpr();
            DATA_TYPE dtT = miningField.getDataType();
            NameExpr dataType = dtT != null ? new NameExpr(dtT.getClass().getName() + "." + dtT.name()) : new NullLiteralExpr();
            MISSING_VALUE_TREATMENT_METHOD mVTM = miningField.getMissingValueTreatmentMethod();
            NameExpr missingValueTreatmentMethod = mVTM != null ? new NameExpr(mVTM.getClass().getName() + "." + mVTM.name()) : new NullLiteralExpr();
            INVALID_VALUE_TREATMENT_METHOD iVTM = miningField.getInvalidValueTreatmentMethod();
            NameExpr invalidValueTreatmentMethod = iVTM != null ? new NameExpr(iVTM.getClass().getName() + "." + iVTM.name()) : new NullLiteralExpr();
            StringLiteralExpr missingValueReplacement = miningField.getMissingValueReplacement() != null ? new StringLiteralExpr(miningField.getMissingValueReplacement()) : new NullLiteralExpr();
            StringLiteralExpr invalidValueReplacement = miningField.getInvalidValueReplacement() != null ? new StringLiteralExpr(miningField.getInvalidValueReplacement()) : new NullLiteralExpr();
            NullLiteralExpr allowedValues = miningField.getAllowedValues() != null ? CommonCodegenUtils.createArraysAsListFromList(miningField.getAllowedValues()).getExpression() : new NullLiteralExpr();
            NullLiteralExpr intervals = miningField.getIntervals() != null ? KiePMMLModelFactoryUtils.createIntervalsExpression(miningField.getIntervals()) : new NullLiteralExpr();
            toReturn.setArguments(NodeList.nodeList((Node[])new Expression[]{name, usageType, opType, dataType, missingValueTreatmentMethod, invalidValueTreatmentMethod, missingValueReplacement, invalidValueReplacement, allowedValues, intervals}));
            return toReturn;
        }).collect(Collectors.toList());
    }

    static Expression createIntervalsExpression(List<Interval> intervals) {
        ExpressionStmt arraysAsListStmt = CommonCodegenUtils.createArraysAsListExpression();
        MethodCallExpr arraysCallExpression = arraysAsListStmt.getExpression().asMethodCallExpr();
        NodeList arguments = new NodeList();
        intervals.forEach(value -> arguments.add((Node)KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval(value)));
        arraysCallExpression.setArguments(arguments);
        arraysAsListStmt.setExpression((Expression)arraysCallExpression);
        return arraysAsListStmt.getExpression();
    }

    static ObjectCreationExpr getObjectCreationExprFromInterval(Interval source) {
        ObjectCreationExpr toReturn = new ObjectCreationExpr();
        toReturn.setType(Interval.class.getCanonicalName());
        NodeList arguments = new NodeList();
        if (source.getLeftMargin() != null) {
            arguments.add((Node)new NameExpr(source.getLeftMargin().toString()));
        } else {
            arguments.add((Node)new NullLiteralExpr());
        }
        if (source.getRightMargin() != null) {
            arguments.add((Node)new NameExpr(source.getRightMargin().toString()));
        } else {
            arguments.add((Node)new NullLiteralExpr());
        }
        toReturn.setArguments(arguments);
        return toReturn;
    }

    static List<ObjectCreationExpr> getOutputFieldsObjectCreations(List<OutputField> outputFields) {
        return outputFields.stream().map(outputField -> {
            ObjectCreationExpr toReturn = new ObjectCreationExpr();
            toReturn.setType(OutputField.class.getCanonicalName());
            StringLiteralExpr name = outputField.getName() != null ? new StringLiteralExpr(outputField.getName()) : new NullLiteralExpr();
            OP_TYPE oPT = outputField.getOpType();
            NameExpr opType = oPT != null ? new NameExpr(oPT.getClass().getName() + "." + oPT.name()) : new NullLiteralExpr();
            DATA_TYPE datT = outputField.getDataType();
            NameExpr dataType = datT != null ? new NameExpr(datT.getClass().getName() + "." + datT.name()) : new NullLiteralExpr();
            StringLiteralExpr targetField = outputField.getTargetField() != null ? new StringLiteralExpr(outputField.getTargetField()) : new NullLiteralExpr();
            RESULT_FEATURE rsltF = outputField.getResultFeature();
            NameExpr resultFeature = rsltF != null ? new NameExpr(rsltF.getClass().getName() + "." + rsltF.name()) : new NullLiteralExpr();
            NullLiteralExpr allowedValues = outputField.getAllowedValues() != null ? CommonCodegenUtils.createArraysAsListFromList(outputField.getAllowedValues()).getExpression() : new NullLiteralExpr();
            toReturn.setArguments(NodeList.nodeList((Node[])new Expression[]{name, opType, dataType, targetField, resultFeature, allowedValues}));
            return toReturn;
        }).collect(Collectors.toList());
    }

    static List<MethodCallExpr> getKiePMMLTargetFieldsObjectCreations(List<TargetField> targetFields) {
        return targetFields.stream().map(KiePMMLTargetFactory::getKiePMMLTargetVariableInitializer).collect(Collectors.toList());
    }

    static void populateTransformationsInConstructor(ConstructorDeclaration constructorDeclaration, String createTransformationDictionary, String createLocalTransformations) {
        MethodCallExpr createTransformationDictionaryInitializer = createTransformationDictionary != null ? new MethodCallExpr((Expression)new NameExpr("this"), createTransformationDictionary, NodeList.nodeList((Node[])new Expression[0])) : new NullLiteralExpr();
        CommonCodegenUtils.setAssignExpressionValue(constructorDeclaration.getBody(), "transformationDictionary", (Expression)createTransformationDictionaryInitializer);
        MethodCallExpr createLocalTransformationsInitializer = createLocalTransformations != null ? new MethodCallExpr((Expression)new NameExpr("this"), createLocalTransformations, NodeList.nodeList((Node[])new Expression[0])) : new NullLiteralExpr();
        CommonCodegenUtils.setAssignExpressionValue(constructorDeclaration.getBody(), "localTransformations", (Expression)createLocalTransformationsInitializer);
    }

    static void commonPopulateGetCreatedKiePMMLMiningFieldsMethod(MethodDeclaration methodDeclaration, List<org.dmg.pmml.MiningField> miningFields, List<Field<?>> fields) {
        BlockStmt body = new BlockStmt();
        NodeList arguments = new NodeList();
        for (org.dmg.pmml.MiningField miningField : miningFields) {
            String miningFieldVariableName = KiePMMLModelUtils.getSanitizedVariableName((String)miningField.getName()).toLowerCase();
            BlockStmt toAdd = KiePMMLMiningFieldFactory.getMiningFieldVariableDeclaration(miningFieldVariableName, miningField, fields);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)body).addStatement(arg_0));
            arguments.add((Node)new NameExpr(miningFieldVariableName));
        }
        MethodCallExpr methodCallExpr = new MethodCallExpr();
        methodCallExpr.setScope((Expression)new NameExpr(Arrays.class.getSimpleName()));
        methodCallExpr.setName("asList");
        methodCallExpr.setArguments(arguments);
        ReturnStmt returnStmt = new ReturnStmt();
        returnStmt.setExpression((Expression)methodCallExpr);
        body.addStatement((Statement)returnStmt);
        methodDeclaration.setBody(body);
    }

    static void commonPopulateGetCreatedKiePMMLOutputFieldsMethod(MethodDeclaration methodDeclaration, List<org.dmg.pmml.OutputField> outputFields) {
        BlockStmt body = new BlockStmt();
        NodeList arguments = new NodeList();
        for (org.dmg.pmml.OutputField outputField : outputFields) {
            String outputFieldVariableName = KiePMMLModelUtils.getSanitizedVariableName((String)outputField.getName()).toLowerCase();
            BlockStmt toAdd = KiePMMLOutputFieldFactory.getOutputFieldVariableDeclaration(outputFieldVariableName, outputField);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)body).addStatement(arg_0));
            arguments.add((Node)new NameExpr(outputFieldVariableName));
        }
        MethodCallExpr methodCallExpr = new MethodCallExpr();
        methodCallExpr.setScope((Expression)new NameExpr(Arrays.class.getSimpleName()));
        methodCallExpr.setName("asList");
        methodCallExpr.setArguments(arguments);
        ReturnStmt returnStmt = new ReturnStmt();
        returnStmt.setExpression((Expression)methodCallExpr);
        body.addStatement((Statement)returnStmt);
        methodDeclaration.setBody(body);
    }
}

