/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDiscretizeBinFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLDiscretizeFactory {
    static final String KIE_PMML_DISCRETIZE_TEMPLATE_JAVA = "KiePMMLDiscretizeTemplate.tmpl";
    static final String KIE_PMML_DISCRETIZE_TEMPLATE = "KiePMMLDiscretizeTemplate";
    static final String GETKIEPMMLDISCRETIZE = "getKiePMMLDiscretize";
    static final String DISCRETIZE = "discretize";
    static final ClassOrInterfaceDeclaration DISCRETIZE_TEMPLATE;

    private KiePMMLDiscretizeFactory() {
    }

    static BlockStmt getDiscretizeVariableDeclaration(String variableName, Discretize discretize) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)DISCRETIZE_TEMPLATE.getMethodsByName(GETKIEPMMLDISCRETIZE).get(0)).clone();
        BlockStmt discretizeBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(discretizeBody, DISCRETIZE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", DISCRETIZE, discretizeBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        int counter = 0;
        NodeList arguments = new NodeList();
        for (DiscretizeBin discretizeBin : discretize.getDiscretizeBins()) {
            String nestedVariableName = String.format("%s_%s", variableName, counter);
            arguments.add((Node)new NameExpr(nestedVariableName));
            BlockStmt toAdd = KiePMMLDiscretizeBinFactory.getDiscretizeBinVariableDeclaration(nestedVariableName, discretizeBin);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
            ++counter;
        }
        ObjectCreationExpr objectCreationExpr = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", DISCRETIZE, toReturn)))).asObjectCreationExpr();
        StringLiteralExpr nameExpr = new StringLiteralExpr(discretize.getField());
        Expression mapMissingToExpr = CommonCodegenUtils.getExpressionForObject(discretize.getMapMissingTo());
        Expression defaultValueExpr = CommonCodegenUtils.getExpressionForObject(discretize.getDefaultValue());
        Expression dataTypeExpression = CommonCodegenUtils.getExpressionForDataType(discretize.getDataType());
        objectCreationExpr.getArguments().set(0, (Node)nameExpr);
        ((Expression)objectCreationExpr.getArguments().get(2)).asMethodCallExpr().setArguments(arguments);
        objectCreationExpr.getArguments().set(3, (Node)mapMissingToExpr);
        objectCreationExpr.getArguments().set(4, (Node)defaultValueExpr);
        objectCreationExpr.getArguments().set(5, (Node)dataTypeExpression);
        discretizeBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_DISCRETIZE_TEMPLATE_JAVA);
        DISCRETIZE_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_DISCRETIZE_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLDiscretizeTemplate"));
        ((MethodDeclaration)DISCRETIZE_TEMPLATE.getMethodsByName(GETKIEPMMLDISCRETIZE).get(0)).clone();
    }
}

