/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.efesto.common.utils.PackageClassNameUtils;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoInputStreamResource;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.PMMLCompilationContextImpl;
import org.kie.pmml.compiler.executor.PMMLCompiler;
import org.kie.pmml.compiler.executor.PMMLCompilerImpl;
import org.kie.pmml.compiler.service.PMMLCompilerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLCompilerServicePMMLInputStream {
    private static final Logger logger = LoggerFactory.getLogger((String)PMMLCompilerServicePMMLInputStream.class.getName());
    private static final PMMLCompiler PMML_COMPILER = new PMMLCompilerImpl();

    private PMMLCompilerServicePMMLInputStream() {
    }

    public static List<EfestoCompilationOutput> getEfestoCompilationOutputPMML(EfestoInputStreamResource resource, EfestoCompilationContext efestoCompilationContext) {
        PMMLCompilationContext pmmlContext = PMMLCompilerServicePMMLInputStream.getPMMLCompilationContext(resource.getFileName(), efestoCompilationContext);
        return PMMLCompilerServicePMMLInputStream.getEfestoCompilationOutputPMML(resource, pmmlContext);
    }

    public static List<EfestoCompilationOutput> getEfestoCompilationOutputPMML(EfestoInputStreamResource resource, PMMLCompilationContext pmmlContext) {
        List<KiePMMLModel> kiePmmlModels = PMMLCompilerServicePMMLInputStream.getKiePMMLModelsFromInputStreamResourcesWithConfigurationsWithSources(pmmlContext, Collections.singletonList(resource));
        return PMMLCompilerService.getEfestoFinalOutputPMML(kiePmmlModels, resource.getFileName(), pmmlContext);
    }

    static PMMLCompilationContext getPMMLCompilationContext(String fileName, EfestoCompilationContext compilationContext) {
        PMMLCompilationContextImpl toReturn = new PMMLCompilationContextImpl(fileName, new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader()));
        toReturn.getGeneratedResourcesMap().putAll(compilationContext.getGeneratedResourcesMap());
        return toReturn;
    }

    static List<KiePMMLModel> getKiePMMLModelsFromInputStreamResourcesWithConfigurationsWithSources(PMMLCompilationContext pmmlContext, Collection<EfestoInputStreamResource> resources) {
        return resources.stream().flatMap(resource -> PMMLCompilerServicePMMLInputStream.getKiePMMLModelsFromResourceWithSources(pmmlContext, resource).stream()).collect(Collectors.toList());
    }

    static List<KiePMMLModel> getKiePMMLModelsFromResourceWithSources(PMMLCompilationContext pmmlContext, EfestoInputStreamResource resource) {
        String[] classNamePackageName = PMMLCompilerServicePMMLInputStream.getFactoryClassNamePackageName(resource);
        String packageName = classNamePackageName[1];
        List<KiePMMLModel> toReturn = PMML_COMPILER.getKiePMMLModelsWithSources(packageName, resource.getContent(), resource.getFileName(), pmmlContext);
        return toReturn;
    }

    static String[] getFactoryClassNamePackageName(EfestoInputStreamResource resource) {
        String sourcePath = resource.getFileName();
        if (sourcePath == null || sourcePath.isEmpty()) {
            throw new IllegalArgumentException("Missing required sourcePath in resource " + resource + " -> " + resource.getClass().getName());
        }
        return PackageClassNameUtils.getFactoryClassNamePackageName((String)"pmml", (String)sourcePath);
    }
}

