/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.factories;

import java.io.File;
import java.util.UUID;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.io.impl.DescrResource;
import org.drools.core.io.impl.FileSystemResource;
import org.drools.modelcompiler.ExecutableModelProject;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KieDescr;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.utils.KieHelper;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLRuntimeFactoryInternal {
    private static final Logger logger = LoggerFactory.getLogger(PMMLRuntimeFactoryInternal.class);

    private PMMLRuntimeFactoryInternal() {
    }

    public static PMMLRuntime getPMMLRuntime(File pmmlFile) {
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder();
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile, kbuilderImpl);
    }

    public static PMMLRuntime getPMMLRuntime(File pmmlFile, ReleaseId releaseId) {
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilderImpl.setReleaseId(releaseId);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile, kbuilderImpl);
    }

    private static PMMLRuntime getPMMLRuntime(File pmmlFile, KnowledgeBuilderImpl kbuilderImpl) {
        FileSystemResource fileSystemResource = new FileSystemResource(pmmlFile);
        new PMMLAssemblerService().addResource(kbuilderImpl, (Resource)fileSystemResource, ResourceType.PMML, null);
        KieBase kieBase = PMMLRuntimeFactoryInternal.createKieBase(kbuilderImpl);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(kieBase);
    }

    private static PMMLRuntime getPMMLRuntime(KieBase kieBase) {
        KieRuntimeFactory kieRuntimeFactory = KieRuntimeFactory.of((KieBase)kieBase);
        return (PMMLRuntime)kieRuntimeFactory.get(PMMLRuntime.class);
    }

    private static KieBase createKieBase(KnowledgeBuilderImpl kbuilderImpl) {
        KieHelper kieHelper = new KieHelper();
        kbuilderImpl.getPackageNames().stream().flatMap(name -> kbuilderImpl.getPackageDescrs(name).stream()).forEach(pDescr -> kieHelper.addResource((Resource)PMMLRuntimeFactoryInternal.createDescrResource(pDescr)));
        KieBase kieBase = kieHelper.build(ExecutableModelProject.class, new KieBaseOption[0]);
        ((InternalKnowledgeBase)kieBase).addPackages(kbuilderImpl.getKnowledgePackages());
        return kieBase;
    }

    private static DescrResource createDescrResource(PackageDescr pDescr) {
        DescrResource resource = new DescrResource((KieDescr)pDescr);
        resource.setSourcePath("src/main/resources/file_" + UUID.randomUUID() + ".descr");
        return resource;
    }
}

