/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.factories;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.io.internal.InternalResource;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.pmml.api.PMMLRuntimeFactory;
import org.kie.pmml.api.exceptions.ExternalException;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.evaluator.assembler.factories.PMMLRuntimeFactoryInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLRuntimeFactoryImpl
implements PMMLRuntimeFactory {
    private static final Logger logger = LoggerFactory.getLogger(PMMLRuntimeFactoryImpl.class);
    private static final KieServices KIE_SERVICES = KieServices.get();

    public PMMLRuntime getPMMLRuntimeFromFile(File pmmlFile) {
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile);
    }

    public PMMLRuntime getPMMLRuntimeFromClasspath(String pmmlFileName) {
        File pmmlFile = this.getPMMLFileFromClasspath(pmmlFileName);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile);
    }

    public PMMLRuntime getPMMLRuntimeFromKieContainerByKieBase(String kieBase, String pmmlFileName, String gav) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(gav);
        File pmmlFile = this.getPMMLFileFromKieContainerByKieBase(pmmlFileName, kieBase, (ReleaseId)releaseId);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile, (ReleaseId)releaseId);
    }

    public PMMLRuntime getPMMLRuntimeFromKieContainerByDefaultKieBase(String pmmlFileName, String gav) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(gav);
        File pmmlFile = this.getPMMLFileFromKieContainerByDefaultKieBase(pmmlFileName, (ReleaseId)releaseId);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile, (ReleaseId)releaseId);
    }

    private File getPMMLFileFromClasspath(String pmmlFileName) {
        return FileUtils.getFile((String[])new String[]{pmmlFileName});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getPMMLFileFromKieContainerByKieBase(String pmmlFileName, String kieBase, ReleaseId releaseId) {
        KieContainerImpl kieContainer = (KieContainerImpl)KIE_SERVICES.newKieContainer(releaseId);
        InternalResource internalResource = ((InternalKieModule)kieContainer.getKieModuleForKBase(kieBase)).getResource(pmmlFileName);
        try (InputStream inputStream = internalResource.getInputStream();){
            File file = this.getPMMLFile(pmmlFileName, inputStream);
            return file;
        }
        catch (Exception e) {
            throw new ExternalException((Throwable)e);
        }
    }

    private File getPMMLFileFromKieContainerByDefaultKieBase(String pmmlFileName, ReleaseId releaseId) {
        KieContainerImpl kieContainer = (KieContainerImpl)KIE_SERVICES.newKieContainer(releaseId);
        String defaultKieBase = kieContainer.getKieProject().getDefaultKieBaseModel().getName();
        return this.getPMMLFileFromKieContainerByKieBase(pmmlFileName, defaultKieBase, releaseId);
    }

    private File getPMMLFile(String fileName, InputStream inputStream) {
        FileOutputStream outputStream = null;
        try {
            int i;
            File toReturn = File.createTempFile(fileName, null);
            outputStream = new FileOutputStream(toReturn);
            byte[] byteArray = new byte[1024];
            while ((i = inputStream.read(byteArray)) > 0) {
                outputStream.write(byteArray, 0, i);
            }
            File file = toReturn;
            return file;
        }
        catch (Exception e) {
            throw new ExternalException((Throwable)e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                logger.warn("Failed to close outputStream", (Throwable)e);
            }
        }
    }
}

