/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.pmml.api.exceptions.ExternalException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.HasRule;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.executor.PMMLCompiler;
import org.kie.pmml.compiler.executor.PMMLCompilerImpl;
import org.kie.pmml.evaluator.assembler.factories.PMMLRuleMapperFactory;
import org.kie.pmml.evaluator.assembler.factories.PMMLRuleMappersFactory;
import org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService;

public class PMMLCompilerService {
    static final String RULES_FILE_NAME = "Rules";

    private PMMLCompilerService() {
    }

    public static List<KiePMMLModel> getKiePMMLModelsFromResourcesWithConfigurationsWithSources(KnowledgeBuilderImpl kbuilderImpl, Collection<ResourceWithConfiguration> resourceWithConfigurations) {
        return resourceWithConfigurations.stream().map(ResourceWithConfiguration::getResource).flatMap(resource -> PMMLCompilerService.getKiePMMLModelsFromResourceWithSources(kbuilderImpl, resource).stream()).collect(Collectors.toList());
    }

    public static List<KiePMMLModel> getKiePMMLModelsCompiledFromResourcesWithConfigurations(KnowledgeBuilderImpl kbuilderImpl, Collection<ResourceWithConfiguration> resourceWithConfigurations) {
        return resourceWithConfigurations.stream().map(ResourceWithConfiguration::getResource).flatMap(resource -> PMMLCompilerService.getKiePMMLModelsCompiledFromResource(kbuilderImpl, resource).stream()).collect(Collectors.toList());
    }

    public static List<KiePMMLModel> getKiePMMLModelsCompiledFromResource(KnowledgeBuilderImpl kbuilderImpl, Resource resource) {
        PMMLCompiler pmmlCompiler = (PMMLCompiler)kbuilderImpl.getCachedOrCreate("PMML_COMPILER_CACHE_KEY", () -> PMMLCompilerService.getCompiler(kbuilderImpl));
        try {
            return pmmlCompiler.getKiePMMLModels(resource.getInputStream(), PMMLCompilerService.getFileName(resource.getSourcePath()), (Object)kbuilderImpl);
        }
        catch (IOException e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    public static List<KiePMMLModel> getKiePMMLModelsFromResourceWithSources(KnowledgeBuilderImpl kbuilderImpl, Resource resource) {
        PMMLCompiler pmmlCompiler = (PMMLCompiler)kbuilderImpl.getCachedOrCreate("PMML_COMPILER_CACHE_KEY", () -> PMMLCompilerService.getCompiler(kbuilderImpl));
        String[] classNamePackageName = PMMLAssemblerService.getFactoryClassNamePackageName(resource);
        String factoryClassName = classNamePackageName[0];
        String packageName = classNamePackageName[1];
        try {
            List toReturn = pmmlCompiler.getKiePMMLModelsWithSources(factoryClassName, packageName, resource.getInputStream(), PMMLCompilerService.getFileName(resource.getSourcePath()), (Object)kbuilderImpl);
            PMMLCompilerService.populateWithPMMLRuleMappers(toReturn, resource);
            return toReturn;
        }
        catch (IOException e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    static void populateWithPMMLRuleMappers(List<KiePMMLModel> toReturn, Resource resource) {
        for (KiePMMLModel kiePMMLModel : toReturn) {
            ArrayList<String> generatedRuleMappers = new ArrayList<String>();
            PMMLCompilerService.addPMMLRuleMapper(kiePMMLModel, generatedRuleMappers, resource.getSourcePath());
            PMMLCompilerService.addPMMLRuleMappers(kiePMMLModel, generatedRuleMappers, resource.getSourcePath());
        }
    }

    static void addPMMLRuleMapper(KiePMMLModel kiePMMLModel, List<String> generatedRuleMappers, String sourcePath) {
        if (!(kiePMMLModel instanceof HasSourcesMap)) {
            String errorMessage = String.format("Expecting HasSourcesMap instance, retrieved %s inside %s", kiePMMLModel.getClass().getName(), sourcePath);
            throw new KiePMMLException(errorMessage);
        }
        if (kiePMMLModel instanceof HasRule) {
            String pkgUUID = ((HasRule)kiePMMLModel).getPkgUUID();
            String rulesFileName = kiePMMLModel.getKModulePackageName() + "." + RULES_FILE_NAME + pkgUUID;
            String pmmlRuleMapper = kiePMMLModel.getKModulePackageName() + "." + "PMMLRuleMapperImpl";
            String ruleMapperSource = PMMLRuleMapperFactory.getPMMLRuleMapperSource(rulesFileName);
            ((HasRule)kiePMMLModel).addSourceMap(pmmlRuleMapper, ruleMapperSource);
            generatedRuleMappers.add(pmmlRuleMapper);
        }
        if (kiePMMLModel instanceof HasNestedModels) {
            for (KiePMMLModel nestedModel : ((HasNestedModels)kiePMMLModel).getNestedModels()) {
                PMMLCompilerService.addPMMLRuleMapper(nestedModel, generatedRuleMappers, sourcePath);
            }
        }
    }

    static void addPMMLRuleMappers(KiePMMLModel kiePMMLModel, List<String> generatedRuleMappers, String sourcePath) {
        if (!(kiePMMLModel instanceof HasSourcesMap)) {
            String errorMessage = String.format("Expecting HasSourcesMap instance, retrieved %s inside %s", kiePMMLModel.getClass().getName(), sourcePath);
            throw new KiePMMLException(errorMessage);
        }
        if (generatedRuleMappers.isEmpty()) {
            return;
        }
        String predictionRuleMapper = kiePMMLModel.getKModulePackageName() + "." + "PMMLRuleMappersImpl";
        String ruleMapperSource = PMMLRuleMappersFactory.getPMMLRuleMappersSource(kiePMMLModel.getKModulePackageName(), generatedRuleMappers);
        ((HasSourcesMap)kiePMMLModel).addSourceMap(predictionRuleMapper, ruleMapperSource);
    }

    static PMMLCompiler getCompiler(KnowledgeBuilderImpl kbuilderImpl) {
        return new PMMLCompilerImpl();
    }

    static String getFileName(String fullPath) {
        String toReturn = fullPath;
        if (fullPath.contains(File.separator)) {
            toReturn = fullPath.substring(fullPath.lastIndexOf(File.separator) + 1);
        } else if (fullPath.contains("/")) {
            toReturn = fullPath.substring(fullPath.lastIndexOf(47) + 1);
        }
        return toReturn;
    }
}

