/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.command;

import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.internal.pmml.PMMLCommandExecutor;
import org.kie.pmml.api.PMMLRuntimeFactory;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.evaluator.assembler.factories.PMMLRuntimeFactoryImpl;
import org.kie.pmml.evaluator.core.PMMLContextImpl;

public class PMMLCommandExecutorImpl
implements PMMLCommandExecutor {
    private static final PMMLRuntimeFactory PMML_RUNTIME_FACTORY = new PMMLRuntimeFactoryImpl();

    public PMML4Result execute(PMMLRequestData pmmlRequestData) {
        this.validate(pmmlRequestData);
        String pmmlFileName = pmmlRequestData.getSource();
        PMMLRuntime pmmlRuntime = this.getPMMLRuntime(pmmlFileName);
        return this.evaluate(pmmlRequestData, pmmlRuntime);
    }

    protected void validate(PMMLRequestData pmmlRequestData) {
        String toValidate = pmmlRequestData.getSource();
        if (toValidate == null || toValidate.isEmpty()) {
            throw new KiePMMLException("Missing required field 'source' with the PMML file name");
        }
        toValidate = pmmlRequestData.getModelName();
        if (toValidate == null || toValidate.isEmpty()) {
            throw new KiePMMLException("Missing required field 'modelName'");
        }
    }

    private PMML4Result evaluate(PMMLRequestData pmmlRequestData, PMMLRuntime pmmlRuntime) {
        String modelName = pmmlRequestData.getModelName();
        PMMLContextImpl pmmlContext = new PMMLContextImpl(pmmlRequestData);
        return pmmlRuntime.evaluate(modelName, (PMMLContext)pmmlContext);
    }

    private PMMLRuntime getPMMLRuntime(String pmmlFileName) {
        return PMML_RUNTIME_FACTORY.getPMMLRuntimeFromClasspath(pmmlFileName);
    }
}

