/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.factories;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.modelcompiler.ExecutableModelProject;
import org.drools.util.io.DescrResource;
import org.drools.util.io.FileSystemResource;
import org.drools.util.io.InternalResource;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KieDescr;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.utils.KieHelper;
import org.kie.pmml.api.exceptions.ExternalException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.evaluator.api.container.PMMLPackage;
import org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLRuntimeFactoryInternal {
    private static final Logger logger = LoggerFactory.getLogger(PMMLRuntimeFactoryInternal.class);
    private static final KieServices KIE_SERVICES = KieServices.get();

    private PMMLRuntimeFactoryInternal() {
    }

    public static PMMLRuntime getPMMLRuntime(File pmmlFile) {
        KieBase kieBase = PMMLRuntimeFactoryInternal.createKieBase(pmmlFile);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(kieBase);
    }

    public static PMMLRuntime getPMMLRuntime(String pmmlFileName) {
        File pmmlFile = PMMLRuntimeFactoryInternal.getPMMLFileFromClasspath(pmmlFileName);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile);
    }

    public static PMMLRuntime getPMMLRuntime(String kieBase, String pmmlFileName, ReleaseId releaseId) {
        File pmmlFile = PMMLRuntimeFactoryInternal.getPMMLFileFromKieContainerByKieBase(pmmlFileName, kieBase, releaseId);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile, releaseId);
    }

    public static PMMLRuntime getPMMLRuntime(String pmmlFileName, ReleaseId releaseId) {
        File pmmlFile = PMMLRuntimeFactoryInternal.getPMMLFileFromKieContainerByDefaultKieBase(pmmlFileName, releaseId);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile, releaseId);
    }

    public static PMMLRuntime getPMMLRuntime(File pmmlFile, ReleaseId releaseId) {
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilderImpl.setReleaseId(releaseId);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(pmmlFile, kbuilderImpl);
    }

    public static PMMLRuntime getPMMLRuntime(KieBase kieBase) {
        KieRuntimeFactory kieRuntimeFactory = KieRuntimeFactory.of((KieBase)kieBase);
        return (PMMLRuntime)kieRuntimeFactory.get(PMMLRuntime.class);
    }

    public static PMMLRuntime getPMMLRuntime(String pmmlFileName, String pmmlModelName, KieBase kieBase) {
        RuleBaseConfiguration ruleBaseConfiguration = new RuleBaseConfiguration(new ClassLoader[]{((InternalKnowledgeBase)kieBase).getRootClassLoader()});
        InternalKnowledgeBase kieBaseNew = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)ruleBaseConfiguration);
        KiePackage kiePackage = PMMLRuntimeFactoryInternal.getKiePackageByModelName(pmmlModelName, kieBase);
        kieBaseNew.addPackage(kiePackage);
        List<KiePackage> nestedKiePackages = PMMLRuntimeFactoryInternal.getNestedKiePackages((InternalKnowledgePackage)kiePackage, kieBase);
        if (!nestedKiePackages.isEmpty()) {
            kieBaseNew.addPackages(nestedKiePackages);
        }
        ((InternalKnowledgePackage)kiePackage).getResourceTypePackages().get(ResourceType.PMML);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime((KieBase)kieBaseNew);
    }

    protected static KieBase createKieBase(File pmmlFile) {
        KieHelper kieHelper = new KieHelper();
        FileSystemResource fileSystemResource = new FileSystemResource(pmmlFile);
        kieHelper.addResource((Resource)fileSystemResource);
        return kieHelper.build(ExecutableModelProject.class, new KieBaseOption[0]);
    }

    protected static KieBase createKieBase(KnowledgeBuilderImpl kbuilderImpl) {
        KieHelper kieHelper = new KieHelper();
        kbuilderImpl.getPackageNames().stream().flatMap(name -> kbuilderImpl.getPackageDescrs(name).stream()).forEach(pDescr -> kieHelper.addResource((Resource)PMMLRuntimeFactoryInternal.createDescrResource(pDescr)));
        KieBase kieBase = kieHelper.build(ExecutableModelProject.class, new KieBaseOption[0]);
        kbuilderImpl.getKnowledgePackages().forEach(kBuilderPackage -> {
            if (kieBase.getKiePackage(kBuilderPackage.getName()) == null) {
                ((InternalKnowledgeBase)kieBase).addPackage(kBuilderPackage);
            }
        });
        kieBase.getKiePackages().forEach(kiePackage -> {
            InternalKnowledgePackage kBuilderPackage;
            PMMLPackage pmmlPackage = (PMMLPackage)((InternalKnowledgePackage)kiePackage).getResourceTypePackages().get(ResourceType.PMML);
            if (pmmlPackage == null && (kBuilderPackage = kbuilderImpl.getPackage(kiePackage.getName())).getResourceTypePackages().get(ResourceType.PMML) != null) {
                ((InternalKnowledgePackage)kiePackage).getResourceTypePackages().put(ResourceType.PMML, kBuilderPackage.getResourceTypePackages().get(ResourceType.PMML));
            }
        });
        return kieBase;
    }

    protected static PMMLRuntime getPMMLRuntime(File pmmlFile, KnowledgeBuilderImpl kbuilderImpl) {
        FileSystemResource fileSystemResource = new FileSystemResource(pmmlFile);
        new PMMLAssemblerService().addResourceAfterRules(kbuilderImpl, (Resource)fileSystemResource, ResourceType.PMML, null);
        KieBase kieBase = PMMLRuntimeFactoryInternal.createKieBase(kbuilderImpl);
        return PMMLRuntimeFactoryInternal.getPMMLRuntime(kieBase);
    }

    protected static DescrResource createDescrResource(PackageDescr pDescr) {
        DescrResource resource = new DescrResource((KieDescr)pDescr);
        resource.setSourcePath("src/main/resources/file_" + UUID.randomUUID() + ".descr");
        return resource;
    }

    protected static KiePackage getKiePackageByModelName(String modelName, KieBase kieBase) {
        return kieBase.getKiePackages().stream().filter(kpkg -> {
            PMMLPackage pmmlPackage = (PMMLPackage)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.PMML);
            return pmmlPackage != null && pmmlPackage.getModelByName(modelName) != null;
        }).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find model " + modelName));
    }

    protected static List<KiePackage> getNestedKiePackages(InternalKnowledgePackage kiePackage, KieBase kieBase) {
        PMMLPackage pmmlPackage = (PMMLPackage)kiePackage.getResourceTypePackages().get(ResourceType.PMML);
        Map kiePmmlModels = pmmlPackage.getAllModels();
        ArrayList<KiePackage> toReturn = new ArrayList<KiePackage>();
        PMMLRuntimeFactoryInternal.populateNestedKiePackageList(kiePmmlModels.values(), toReturn, kieBase);
        return toReturn;
    }

    protected static void populateNestedKiePackageList(Collection<KiePMMLModel> kiePmmlModels, List<KiePackage> toPopulate, KieBase kieBase) {
        kiePmmlModels.forEach(kiePmmlModel -> {
            if (kiePmmlModel instanceof HasNestedModels) {
                List nestedModels = ((HasNestedModels)kiePmmlModel).getNestedModels();
                nestedModels.forEach(nestedModel -> toPopulate.add(PMMLRuntimeFactoryInternal.getKiePackageByFullClassName(nestedModel.getClass().getName(), kieBase)));
                PMMLRuntimeFactoryInternal.populateNestedKiePackageList(nestedModels, toPopulate, kieBase);
            }
        });
    }

    protected static KiePackage getKiePackageByFullClassName(String fullClassName, KieBase kieBase) {
        return kieBase.getKiePackages().stream().filter(kpkg -> {
            PMMLPackage pmmlPackage = (PMMLPackage)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.PMML);
            return pmmlPackage != null && pmmlPackage.getModelByFullClassName(fullClassName) != null;
        }).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find model " + fullClassName));
    }

    private static File getPMMLFileFromClasspath(String pmmlFileName) {
        return FileUtils.getFile((String[])new String[]{pmmlFileName});
    }

    private static File getPMMLFileFromKieContainerByKieBase(String pmmlFileName, String kieBase, ReleaseId releaseId) {
        File file;
        block8: {
            KieContainerImpl kieContainer = (KieContainerImpl)KIE_SERVICES.newKieContainer(releaseId);
            InternalResource internalResource = ((InternalKieModule)kieContainer.getKieModuleForKBase(kieBase)).getResource(pmmlFileName);
            InputStream inputStream = internalResource.getInputStream();
            try {
                file = PMMLRuntimeFactoryInternal.getPMMLFile(pmmlFileName, inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ExternalException((Throwable)e);
                }
            }
            inputStream.close();
        }
        return file;
    }

    private static File getPMMLFileFromKieContainerByDefaultKieBase(String pmmlFileName, ReleaseId releaseId) {
        KieContainerImpl kieContainer = (KieContainerImpl)KIE_SERVICES.newKieContainer(releaseId);
        String defaultKieBase = kieContainer.getKieProject().getDefaultKieBaseModel().getName();
        return PMMLRuntimeFactoryInternal.getPMMLFileFromKieContainerByKieBase(pmmlFileName, defaultKieBase, releaseId);
    }

    private static File getPMMLFile(String fileName, InputStream inputStream) {
        FileOutputStream outputStream = null;
        try {
            int i;
            File toReturn = File.createTempFile(fileName, null);
            outputStream = new FileOutputStream(toReturn);
            byte[] byteArray = new byte[1024];
            while ((i = inputStream.read(byteArray)) > 0) {
                outputStream.write(byteArray, 0, i);
            }
            File file = toReturn;
            return file;
        }
        catch (Exception e) {
            throw new ExternalException((Throwable)e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                logger.warn("Failed to close outputStream", (Throwable)e);
            }
        }
    }
}

