/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.evaluator;

import java.util.Map;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluator;
import org.kie.pmml.evaluator.core.utils.Converter;
import org.kie.pmml.models.tree.model.KiePMMLTreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLTreeModelEvaluator
implements PMMLModelEvaluator<KiePMMLTreeModel> {
    private static final Logger logger = LoggerFactory.getLogger(PMMLTreeModelEvaluator.class);

    public PMML_MODEL getPMMLModelType() {
        return PMML_MODEL.TREE_MODEL;
    }

    public PMML4Result evaluate(KiePMMLTreeModel model, PMMLRuntimeContext pmmlContext) {
        logger.trace("evaluate {} {}", (Object)model, (Object)pmmlContext);
        Map requestData = Converter.getUnwrappedParametersMap((Map)pmmlContext.getRequestData().getMappedRequestParams());
        PMML4Result toReturn = new PMML4Result();
        String targetField = model.getTargetField();
        Object result = model.evaluate(requestData, pmmlContext);
        toReturn.addResultVariable(targetField, result);
        toReturn.setResultObjectName(targetField);
        toReturn.setResultCode(ResultCode.OK.getName());
        return toReturn;
    }
}

