/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.model;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.tuples.KiePMMLProbabilityConfidence;
import org.kie.pmml.models.tree.model.KiePMMLNodeResult;
import org.kie.pmml.models.tree.model.KiePMMLScoreDistribution;

public class KiePMMLNode
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = -3166618610223066816L;

    protected KiePMMLNode(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    protected static LinkedHashMap<String, KiePMMLProbabilityConfidence> getProbabilityConfidenceMap(List<KiePMMLScoreDistribution> kiePMMLScoreDistributions, double missingValuePenalty) {
        return kiePMMLScoreDistributions != null && !kiePMMLScoreDistributions.isEmpty() ? KiePMMLNode.evaluateProbabilityConfidenceMap(kiePMMLScoreDistributions, missingValuePenalty) : new LinkedHashMap<String, KiePMMLProbabilityConfidence>();
    }

    protected static Optional<KiePMMLNodeResult> getNestedKiePMMLNodeResult(List<Function<Map<String, Object>, KiePMMLNodeResult>> nodeFunctions, Map<String, Object> requestData) {
        Function<Map<String, Object>, KiePMMLNodeResult> function;
        KiePMMLNodeResult evaluation;
        Optional<KiePMMLNodeResult> toReturn = Optional.empty();
        Iterator<Function<Map<String, Object>, KiePMMLNodeResult>> iterator = nodeFunctions.iterator();
        while (iterator.hasNext() && !(toReturn = Optional.ofNullable(evaluation = (function = iterator.next()).apply(requestData))).isPresent()) {
        }
        return toReturn;
    }

    static LinkedHashMap<String, KiePMMLProbabilityConfidence> evaluateProbabilityConfidenceMap(List<KiePMMLScoreDistribution> kiePMMLScoreDistributions, double missingValuePenalty) {
        LinkedHashMap<String, KiePMMLProbabilityConfidence> toReturn = new LinkedHashMap<String, KiePMMLProbabilityConfidence>();
        if (kiePMMLScoreDistributions == null || kiePMMLScoreDistributions.isEmpty()) {
            return toReturn;
        }
        if (kiePMMLScoreDistributions.get(0).hasProbability()) {
            for (KiePMMLScoreDistribution kiePMMLScoreDistribution : kiePMMLScoreDistributions) {
                toReturn.put(kiePMMLScoreDistribution.getValue(), new KiePMMLProbabilityConfidence(kiePMMLScoreDistribution.getProbability(), kiePMMLScoreDistribution.getEvaluatedConfidence(missingValuePenalty)));
            }
        } else {
            int totalRecordCount = kiePMMLScoreDistributions.stream().map(KiePMMLScoreDistribution::getRecordCount).reduce(0, Integer::sum);
            for (KiePMMLScoreDistribution kiePMMLScoreDistribution : kiePMMLScoreDistributions) {
                toReturn.put(kiePMMLScoreDistribution.getValue(), new KiePMMLProbabilityConfidence(kiePMMLScoreDistribution.getEvaluatedProbability(totalRecordCount), kiePMMLScoreDistribution.getEvaluatedConfidence(missingValuePenalty)));
            }
        }
        return toReturn;
    }
}

