/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.jms;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.scanner.MavenRepository;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class KieServerBaseIntegrationTest {
    @Parameterized.Parameter
    public MarshallingFormat FORMAT;
    private static Logger logger = LoggerFactory.getLogger(KieServerBaseIntegrationTest.class);
    private static final String DEFAULT_USERNAME = "yoda";
    private static final String DEFAULT_PASSWORD = "usetheforce123@";
    private static final String INITIAL_CONTEXT_FACTORY = "org.jboss.naming.remote.client.InitialContextFactory";
    private static final String PROVIDER_URL = System.getProperty("remoting.uri", "remote://localhost:4447");
    protected static String BASE_URI = System.getProperty("kie.server.base.uri");
    private static MavenRepository repository;
    protected KieServicesClient client;
    private static boolean commonParentDeployed;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MarshallingFormat.JAXB}, {MarshallingFormat.JSON});
    }

    @BeforeClass
    public static void logSettings() {
        logger.debug("Kie Server base URI: " + BASE_URI);
    }

    @Before
    public void setup() throws Exception {
        this.startClient();
        this.disposeAllContainers();
    }

    @After
    public void tearDown() {
    }

    protected void disposeAllContainers() {
        ServiceResponse response = this.client.listContainers();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
        List containers = ((KieContainerResourceList)response.getResult()).getContainers();
        for (KieContainerResource container : containers) {
            this.client.disposeContainer(container.getContainerId());
        }
    }

    private void startClient() throws Exception {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", System.getProperty("java.naming.provider.url", PROVIDER_URL));
        env.put("java.naming.security.principal", System.getProperty("username", DEFAULT_USERNAME));
        env.put("java.naming.security.credentials", System.getProperty("password", DEFAULT_PASSWORD));
        InitialContext context = new InitialContext(env);
        KieServicesConfiguration conf = KieServicesFactory.newJMSConfiguration((InitialContext)context, (String)DEFAULT_USERNAME, (String)DEFAULT_PASSWORD);
        conf.setMarshallingFormat(this.FORMAT);
        this.client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)conf);
    }

    protected static void createAndDeployKJar(ReleaseId releaseId) {
        String drl = "package org.pkg1\nglobal java.util.List list;declare Message\n    text : String\nend\nrule echo dialect \"mvel\"\nwhen\n    $m : Message()\nthen\n    $m.text = \"echo:\" + $m.text;\nend\nrule X when\n    msg : String()\nthen\n    list.add(msg);\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieServerBaseIntegrationTest.createAndDeployJar(ks, releaseId, drl);
        ks.getRepository().removeKieModule((org.kie.api.builder.ReleaseId)releaseId);
    }

    private static void createAndDeployJar(KieServices ks, ReleaseId releaseId, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)releaseId);
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/org/pkg1/r" + i + ".drl", drls[i]);
        }
        byte[] pom = kfs.read("pom.xml");
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertFalse((String)kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).toString(), (boolean)kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule((org.kie.api.builder.ReleaseId)releaseId);
        byte[] jar = kieModule.getBytes();
        repository = MavenRepository.getMavenRepository();
        repository.deployArtifact((org.kie.api.builder.ReleaseId)releaseId, jar, pom);
    }

    public static int findFreePort() {
        int port = 0;
        try {
            ServerSocket server = new ServerSocket(0);
            port = server.getLocalPort();
            server.close();
        }
        catch (IOException e) {
            port = 9789;
        }
        System.out.println("Allocating port: " + port);
        return port;
    }

    protected void assertSuccess(ServiceResponse<?> response) {
        ServiceResponse.ResponseType type = response.getType();
        Assert.assertEquals((String)("Expected SUCCESS, but got " + type + "! Response: " + response), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)type);
    }

    protected void assertResultContainsString(String result, String expectedString) {
        Assert.assertTrue((String)("Expecting string '" + expectedString + "' in result, but got: " + result), (boolean)result.contains(expectedString));
    }

    protected void assertResultContainsStringRegex(String result, String regex) {
        Assert.assertTrue((String)("Regex '" + regex + "' does not matches result string '" + result + "'!"), (boolean)Pattern.compile(regex, 32).matcher(result).matches());
    }

    static {
        commonParentDeployed = false;
    }
}

