/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.util.ArrayList;
import java.util.List;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.Person;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.command.CommandFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringBasicsDecisionTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/decision/decision-beans.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)context.getBean("decisionCSV");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testDecisionTableRules() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("ksession-table-1");
        Assert.assertNotNull((Object)ksession);
        Cheese cheese = new Cheese();
        cheese.setPrice(250);
        cheese.setType("cheddar");
        Person person = new Person();
        person.setName("Young Scott");
        person.setAge(21);
        ArrayList<Command> cmds = new ArrayList<Command>();
        cmds.add(CommandFactory.newSetGlobal((String)"list", new ArrayList(), (boolean)true));
        cmds.add(CommandFactory.newInsert((Object)person, (String)"yscott"));
        cmds.add(CommandFactory.newInsert((Object)cheese, (String)"cheddar"));
        cmds.add(CommandFactory.newFireAllRules());
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
        List list = (List)results.getValue("list");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Young man cheddar"));
        person = new Person();
        person.setName("Old Scott");
        person.setAge(42);
        cheese = new Cheese();
        cheese.setPrice(150);
        cheese.setType("stilton");
        cmds = new ArrayList();
        cmds.add(CommandFactory.newSetGlobal((String)"list", new ArrayList(), (boolean)true));
        cmds.add(CommandFactory.newInsert((Object)person, (String)"oscott"));
        cmds.add(CommandFactory.newInsert((Object)cheese, (String)"stilton"));
        cmds.add(CommandFactory.newFireAllRules());
        results = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
        list = (List)results.getValue("list");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Old man stilton"));
    }

    @AfterClass
    public static void tearDown() {
    }
}

