/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests.annotations;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.spring.beans.annotations.BeanWithReleaseId;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class WithReleaseIdInjectionTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/annotations/annotations-releaseId.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testKContainer() throws Exception {
        BeanWithReleaseId sampleBean = (BeanWithReleaseId)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieContainer());
        Assert.assertTrue((boolean)(sampleBean.getKieContainer() instanceof KieContainer));
        ReleaseId releaseId = sampleBean.getKieContainer().getReleaseId();
        Assert.assertTrue((boolean)"named-kiesession".equalsIgnoreCase(releaseId.getArtifactId()));
    }

    @Test
    public void testKieBase() throws Exception {
        BeanWithReleaseId sampleBean = (BeanWithReleaseId)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieBase());
        Assert.assertTrue((boolean)(sampleBean.getKieBase() instanceof KieBase));
    }

    @AfterClass
    public static void tearDown() {
    }
}

