/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.logging;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredPatternLayoutTest {
    private static ByteArrayOutputStream baos;
    private static PrintStream originalOut;

    @BeforeClass
    public static void setup() {
        baos = new ByteArrayOutputStream();
        PrintStream loggingStream = new PrintStream(baos);
        originalOut = System.out;
        System.setOut(loggingStream);
    }

    @AfterClass
    public static void cleanup() {
        System.setOut(originalOut);
    }

    @Test
    public void layoutTest() {
        Logger logger = LoggerFactory.getLogger(FilteredPatternLayoutTest.class);
        String msg = "logger test exception";
        logger.warn(msg, (Throwable)new RuntimeException(msg));
        String[] filtered = new String[]{"sun.reflect", "org.junit", "org.eclipse.jdt.internal"};
        String output = new String(baos.toByteArray());
        for (String pkgName : filtered) {
            Assert.assertFalse((String)("Package name in logging: " + pkgName), (boolean)output.contains(pkgName));
        }
    }
}

