/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.filesystem;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.test.util.filesystem.ResourceHelper;

public class ResourceHelperTest {
    private static final String TEST_FILE = "TestFile.txt";

    @Test
    public void getResourcesByExtensionExisting() {
        Stream retrieved = ResourceHelper.getResourcesByExtension((String)"txt");
        this.commonVerifyStream(retrieved, TEST_FILE);
    }

    @Test
    public void getResourcesByExtensionNotExisting() {
        Stream retrieved = ResourceHelper.getResourcesByExtension((String)"arg");
        this.commonVerifyStream(retrieved, null);
    }

    @Test
    public void getResourcesFromDirectoryExisting() {
        File directory = new File("." + File.separator + "target" + File.separator + "test-classes");
        Pattern pattern = Pattern.compile(".*txt");
        Stream retrieved = ResourceHelper.getResourcesFromDirectory((File)directory, (Pattern)pattern);
        this.commonVerifyStream(retrieved, TEST_FILE);
    }

    @Test
    public void getResourcesFromDirectoryNotExisting() {
        File directory = new File("." + File.separator + "target" + File.separator + "test-classes");
        Pattern pattern = Pattern.compile(".*arg");
        Stream retrieved = ResourceHelper.getResourcesFromDirectory((File)directory, (Pattern)pattern);
        this.commonVerifyStream(retrieved, null);
    }

    @Test
    public void getClassPathElements() {
        Object[] retrieved = ResourceHelper.getClassPathElements();
        Assertions.assertThat((Object[])retrieved).isNotNull();
        Assertions.assertThat((retrieved.length == 0 ? 1 : 0) != 0).isFalse();
    }

    @Test
    public void internalGetResourcesExisting() {
        String path = "." + File.separator + "target" + File.separator + "test-classes";
        Pattern pattern = Pattern.compile(".*txt");
        Stream retrieved = ResourceHelper.internalGetResources((String)path, (Pattern)pattern);
        this.commonVerifyStream(retrieved, TEST_FILE);
    }

    @Test
    public void internalGetResourcesNotExisting() {
        String path = "." + File.separator + "target" + File.separator + "test-classes";
        Pattern pattern = Pattern.compile(".*arg");
        Stream retrieved = ResourceHelper.internalGetResources((String)path, (Pattern)pattern);
        this.commonVerifyStream(retrieved, null);
    }

    private void commonVerifyStream(Stream<File> toVerify, String expectedFile) {
        Assertions.assertThat(toVerify).isNotNull();
        List retrieved = toVerify.collect(Collectors.toList());
        if (expectedFile != null) {
            Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
            Assertions.assertThat((boolean)((File)retrieved.get(0)).exists()).isTrue();
            Assertions.assertThat((String)((File)retrieved.get(0)).getName()).isEqualTo(expectedFile);
        } else {
            Assertions.assertThat((boolean)retrieved.isEmpty()).isTrue();
        }
    }
}

