/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.db.internal;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.managed.BasicManagedDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PoolingDataSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(PoolingDataSourceFactory.class);
    private static final String PROP_USERNAME = "username";
    private static final String PROP_PASSWORD = "password";

    PoolingDataSourceFactory() {
    }

    static XAResourceRecoveryHelper getXAResourceRecoveryHelper(final XADataSource xaDataSource, final Properties properties) {
        return new XAResourceRecoveryHelper(){
            private final Object lock = new Object();
            private XAConnection connection;

            public boolean initialise(String p) throws Exception {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized XAResource[] getXAResources() throws Exception {
                Object object = this.lock;
                synchronized (object) {
                    this.initialiseConnection();
                    try {
                        return new XAResource[]{this.connection.getXAResource()};
                    }
                    catch (SQLException ex) {
                        return new XAResource[0];
                    }
                }
            }

            private void initialiseConnection() throws SQLException {
                if (this.connection == null) {
                    String user = properties.getProperty(PoolingDataSourceFactory.PROP_USERNAME);
                    String password = properties.getProperty(PoolingDataSourceFactory.PROP_PASSWORD);
                    this.connection = user != null && password != null ? xaDataSource.getXAConnection(user, password) : xaDataSource.getXAConnection();
                    this.connection.addConnectionEventListener(new ConnectionEventListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void connectionClosed(ConnectionEvent event) {
                            log.warn("The connection was closed: " + connection);
                            Object object = lock;
                            synchronized (object) {
                                connection = null;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void connectionErrorOccurred(ConnectionEvent event) {
                            log.warn("A connection error occurred: " + connection);
                            Object object = lock;
                            synchronized (object) {
                                try {
                                    connection.close();
                                }
                                catch (SQLException e) {
                                    log.warn("Could not close failing connection: " + connection);
                                }
                                connection = null;
                            }
                        }
                    });
                }
            }
        };
    }

    static DataSource createPoolingDataSource(TransactionManager transactionManager, XADataSource xaDataSource, TransactionSynchronizationRegistry tsr, Properties properties) {
        if (transactionManager != null && xaDataSource != null) {
            String initialSize = properties.getProperty("initialSize");
            properties.remove("initialSize");
            BasicManagedDataSource mds = new BasicManagedDataSource();
            try (BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);){
                for (Field field : ds.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    if (field.get(ds) == null || Modifier.isFinal(field.getModifiers())) continue;
                    field.set(mds, field.get(ds));
                }
                mds.setTransactionManager(transactionManager);
                mds.setXaDataSourceInstance(xaDataSource);
                mds.setTransactionSynchronizationRegistry(tsr);
                if (initialSize != null) {
                    mds.setInitialSize(Integer.parseInt(initialSize));
                    if (mds.getInitialSize() > 0) {
                        mds.getLogWriter();
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            XARecoveryModule xaRecoveryModule = PoolingDataSourceFactory.getXARecoveryModule();
            if (xaRecoveryModule != null) {
                xaRecoveryModule.addXAResourceRecoveryHelper(PoolingDataSourceFactory.getXAResourceRecoveryHelper(xaDataSource, properties));
            }
            return mds;
        }
        return null;
    }

    private static XARecoveryModule getXARecoveryModule() {
        XARecoveryModule xaRecoveryModule = XARecoveryModule.getRegisteredXARecoveryModule();
        if (xaRecoveryModule != null) {
            return xaRecoveryModule;
        }
        throw new IllegalStateException("XARecoveryModule is not registered with recovery manager");
    }
}

