/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.tomcat;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.users.AbstractRole;
import org.apache.catalina.users.AbstractUser;
import org.apache.catalina.valves.ValveBase;

public class JACCValve
extends ValveBase {
    private static ThreadLocal<Request> currentRequest = new ThreadLocal();

    public JACCValve() {
        try {
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)new PolicyContextHandler(){

                public boolean supports(String key) throws PolicyContextException {
                    return "javax.security.auth.Subject.container".equals(key);
                }

                public String[] getKeys() throws PolicyContextException {
                    return new String[]{"javax.security.auth.Subject.container"};
                }

                public Object getContext(String key, Object data) throws PolicyContextException {
                    Request req = (Request)currentRequest.get();
                    if (req == null || req.getPrincipal() == null) {
                        return null;
                    }
                    HashSet<Principal> principals = new HashSet<Principal>();
                    principals.add(req.getPrincipal());
                    principals.add((Principal)JACCValve.this.getGroup(req.getPrincipal()));
                    Subject s = new Subject(false, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
                    return s;
                }
            }, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        currentRequest.set(request);
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            currentRequest.set(null);
        }
    }

    protected Group getGroup(Principal principal) {
        Group group;
        block3: {
            String[] roles;
            block2: {
                group = new Group(){
                    private List<Principal> members = new ArrayList<Principal>();

                    public String getName() {
                        return "Roles";
                    }

                    public boolean removeMember(Principal user) {
                        return this.members.remove(user);
                    }

                    public Enumeration<? extends Principal> members() {
                        return Collections.enumeration(this.members);
                    }

                    public boolean isMember(Principal member) {
                        return this.members.contains(member);
                    }

                    public boolean addMember(Principal user) {
                        return this.members.add(user);
                    }
                };
                if (!(principal instanceof AbstractUser)) break block2;
                Iterator it = ((AbstractUser)principal).getRoles();
                while (it.hasNext()) {
                    AbstractRole user = (AbstractRole)it.next();
                    group.addMember((Principal)user);
                }
                break block3;
            }
            if (!(principal instanceof GenericPrincipal)) break block3;
            for (final String role : roles = ((GenericPrincipal)principal).getRoles()) {
                group.addMember(new Principal(){

                    @Override
                    public String getName() {
                        return role;
                    }
                });
            }
        }
        return group;
    }
}

