/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps;

import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;

public class HomePerspective
extends AbstractPerspective {
    private static final By CAROUSEL = By.className((String)"carousel-caption");
    private static final int DEFAULT_HOME_PERSP_LOADING_TIMEOUT_SECONDS = 15;
    private static final int HOME_PERSP_LOADING_TIMEOUT_SECONDS = HomePerspective.getTimeoutSeconds();

    @Override
    public void waitForLoaded() {
        Waits.elementPresent(CAROUSEL, HOME_PERSP_LOADING_TIMEOUT_SECONDS);
    }

    @Override
    public boolean isDisplayed() {
        try {
            Waits.elementPresent(CAROUSEL, 2);
            return true;
        }
        catch (NoSuchElementException nse) {
            return false;
        }
    }

    private static int getTimeoutSeconds() {
        String timeout = System.getProperty("selenium.homepage.loading.timeout.seconds");
        try {
            return Integer.parseInt(timeout);
        }
        catch (NumberFormatException nfe) {
            return 15;
        }
    }
}

