/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.ui;

import org.junit.Assert;
import org.junit.Test;
import org.kie.wb.selenium.model.KieSeleniumTest;
import org.kie.wb.selenium.model.Persp;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.model.persps.HomePerspective;
import org.kie.wb.selenium.model.persps.ProjectAuthoringPerspective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadAllPerspectivesIntegrationTest
extends KieSeleniumTest {
    private static final Logger LOG = LoggerFactory.getLogger(LoadAllPerspectivesIntegrationTest.class);

    @Test
    public void allPerspectivesCanBeLoaded() {
        this.login.getLoginPage();
        HomePerspective home = this.login.loginDefaultUser();
        for (Persp p : Persp.getAllPerspectives()) {
            if (!this.perspectiveInCurrentWebApp(p)) continue;
            Persp _p = p;
            LOG.info("Checking perspective '" + p.getName() + "..");
            AbstractPerspective perspective = home.getNavbar().navigateTo(_p);
            if (perspective instanceof ProjectAuthoringPerspective && ((ProjectAuthoringPerspective)perspective).isAuthoringDisabled()) {
                LOG.info("No projects in Workbench. Redirected to ProjectLibraryPerspective.");
                continue;
            }
            LOG.info("Navigated to perspective '" + _p.getName() + "..");
            Assert.assertTrue((String)("Perspective " + _p.getName() + " should be loaded"), (boolean)perspective.isDisplayed());
        }
        home.logout();
    }

    private boolean perspectiveInCurrentWebApp(Persp persp) {
        return IS_KIE_WB || !persp.isKieWbOnly();
    }
}

