/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.ui;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.wb.selenium.model.KieSeleniumTest;
import org.kie.wb.selenium.model.persps.ArtifactRepositoryPerspective;
import org.kie.wb.selenium.model.persps.HomePerspective;
import org.kie.wb.selenium.model.persps.ProjectLibraryPerspective;
import org.kie.wb.selenium.util.Repository;
import org.kie.wb.selenium.util.Waits;

public class ProjectLibraryIntegrationTest
extends KieSeleniumTest {
    private static final String MORTGAGES_PROJECT = "mortgages";
    private HomePerspective home;
    private ProjectLibraryPerspective projectLibrary;

    @Before
    public void setUp() {
        this.login.getLoginPage();
        if (this.login.isDisplayed()) {
            this.home = this.login.loginDefaultUser();
        }
        this.projectLibrary = this.home.getNavbar().projectAuthoring();
        if (this.projectLibrary.isProjectListEmpty()) {
            this.projectLibrary.importDemoProject(MORTGAGES_PROJECT);
            Waits.pause((int)5000);
            this.projectLibrary.openProjectList();
        }
    }

    @After
    public void cleanUp() {
        this.home.logout();
    }

    @Test
    public void importAndBuildProjectFromStockRepository() {
        this.projectLibrary.importStockExampleProject("MyRepo", "MyOrgUnit", new String[]{"optacloud"});
        this.deployAndCheckArtifact("optacloud:optacloud:1.0.0-SNAPSHOT");
    }

    @Test
    public void importAndBuildProjectFromCustomRepository() {
        this.projectLibrary.importCustomExampleProject(Repository.JBPM_PLAYGROUND, "MyRepo", "MyOrgUnit", new String[]{"Evaluation"});
        this.deployAndCheckArtifact("org.jbpm:Evaluation:1.0");
    }

    private void deployAndCheckArtifact(String artifact) {
        this.projectLibrary.buildAndDeployProject();
        Waits.pause((int)10000);
        ArtifactRepositoryPerspective artifactRepo = this.projectLibrary.getNavbar().artifactRepository();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)artifactRepo.isArtifactPresent(artifact)).as("Project artifact should be present after Build & Deploy", new Object[0])).isTrue();
    }
}

