/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps.authoring;

import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.kie.wb.selenium.model.widgets.ModalDialog;
import org.kie.wb.selenium.util.ByUtil;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class ImportExampleModal
extends ModalDialog {
    @FindByJQuery(value="#stockRadio")
    private WebElement stockRepositoryRadioOption;
    @FindByJQuery(value="#customRadio")
    private WebElement customRepositoryRadioOption;
    @FindByJQuery(value="#repositoryUrlInput")
    private WebElement repoUrlInput;
    @FindByJQuery(value="#targetRepositoryTextBox")
    private WebElement targetRepoInput;
    @FindByJQuery(value="#organizationalUnitsDropdown > input")
    private WebElement targetOrgUnit;

    public static ImportExampleModal newInstance() {
        if (Waits.isElementPresent(ByUtil.jquery(".modal-content:has(.modal-header:contains('ExamplesWizard'))", 40))) {
            return ModalDialog.newInstance(ImportExampleModal.class, "ExamplesWizard");
        }
        return ModalDialog.newInstance(ImportExampleModal.class, "Import Example");
    }

    public void selectStockRepository() {
        this.stockRepositoryRadioOption.click();
        this.next();
        Waits.elementPresent(By.id((String)"projects"));
    }

    public void selectCustomRepository(String repoUrl) {
        this.customRepositoryRadioOption.click();
        this.repoUrlInput.clear();
        this.repoUrlInput.sendKeys(new CharSequence[]{repoUrl});
        this.repoUrlInput.sendKeys(new CharSequence[]{Keys.TAB});
        this.next();
        Waits.elementPresent(By.id((String)"projects"));
    }

    public void selectProjects(String ... projects) {
        for (String proj : projects) {
            this.selectProject(proj);
        }
        this.next();
    }

    private void selectProject(String project) {
        By projCheckboxLoc = ByUtil.xpath("//input[following-sibling::span[contains(text(),'%s')]]", project);
        WebElement checkbox = Waits.elementPresent(projCheckboxLoc, 10);
        checkbox.click();
    }

    public void setTargetRepoAndOrgUnit(String repoName, String orgUnit) {
        this.targetRepoInput.sendKeys(new CharSequence[]{repoName});
        this.targetOrgUnit.sendKeys(new CharSequence[]{orgUnit});
        this.targetRepoInput.click();
        this.finish();
    }
}

