/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.client;

import java.util.Collection;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.guvnor.rest.client.AddRepositoryToOrganizationalUnitRequest;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.DeleteProjectRequest;
import org.guvnor.rest.client.DeployProjectRequest;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.ProjectRequest;
import org.guvnor.rest.client.ProjectResponse;
import org.guvnor.rest.client.RemoveOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryFromOrganizationalUnitRequest;
import org.guvnor.rest.client.RemoveRepositoryRequest;
import org.guvnor.rest.client.RepositoryRequest;
import org.guvnor.rest.client.RepositoryResponse;
import org.guvnor.rest.client.TestProjectRequest;
import org.guvnor.rest.client.UpdateOrganizationalUnit;
import org.guvnor.rest.client.UpdateOrganizationalUnitRequest;
import org.kie.wb.test.rest.client.Authenticator;
import org.kie.wb.test.rest.client.NotSuccessException;
import org.kie.wb.test.rest.client.WorkbenchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestWorkbenchClient
implements WorkbenchClient {
    private static final Logger log = LoggerFactory.getLogger(RestWorkbenchClient.class);
    private static final int JOB_TIMEOUT_SECONDS = 10;
    private static final int PROJECT_JOB_TIMEOUT_SECONDS = 60;
    private static final int CLONE_REPO_TIMEOUT_SECONDS = 60;
    private static final MediaType MEDIA_TYPE = MediaType.APPLICATION_JSON_TYPE;
    private final boolean async;
    private final WebTarget target;

    private RestWorkbenchClient(String appUrl, String userId, String password, boolean async) {
        this.async = async;
        Client client = (Client)ClientBuilder.newClient().register((Object)new Authenticator(userId, password));
        this.target = client.target(appUrl).path("rest");
    }

    public static WorkbenchClient createAsyncWorkbenchClient(String appUrl, String userId, String password) {
        return new RestWorkbenchClient(appUrl, userId, password, true);
    }

    public static WorkbenchClient createWorkbenchClient(String appUrl, String userId, String password) {
        return new RestWorkbenchClient(appUrl, userId, password, false);
    }

    @Override
    public JobResult getJob(String jobId) {
        log.info("Getting job '{}'", (Object)jobId);
        return (JobResult)this.target.path("jobs/{jobId}").resolveTemplate("jobId", (Object)jobId).request().get(JobResult.class);
    }

    @Override
    public JobResult deleteJob(String jobId) {
        log.info("Deleting job '{}'", (Object)jobId);
        return (JobResult)this.target.path("jobs/{jobId}").resolveTemplate("jobId", (Object)jobId).request().delete(JobResult.class);
    }

    @Override
    public Collection<RepositoryResponse> getRepositories() {
        log.info("Getting all repositories");
        return (Collection)this.target.path("repositories").request().get((GenericType)new GenericType<Collection<RepositoryResponse>>(){});
    }

    @Override
    public RepositoryResponse getRepository(String repositoryName) {
        log.info("Getting repository '{}'", (Object)repositoryName);
        return (RepositoryResponse)this.target.path("repositories/{repositoryName}").resolveTemplate("repositoryName", (Object)repositoryName).request().get(RepositoryResponse.class);
    }

    @Override
    public CreateOrCloneRepositoryRequest createOrCloneRepository(RepositoryRequest repository) {
        log.info("Creating new repository '{}'", (Object)repository.getName());
        CreateOrCloneRepositoryRequest request = (CreateOrCloneRepositoryRequest)this.target.path("repositories").request().post(this.createEntity(repository), CreateOrCloneRepositoryRequest.class);
        if (request.getRepository().getRequestType().equals("clone")) {
            return this.waitUntilJobFinished(request, 60);
        }
        return this.waitUntilJobFinished(request);
    }

    @Override
    public RemoveRepositoryRequest deleteRepository(String repositoryName) {
        log.info("Deleting repository '{}'", (Object)repositoryName);
        RemoveRepositoryRequest request = (RemoveRepositoryRequest)this.target.path("repositories/{repositoryName}").resolveTemplate("repositoryName", (Object)repositoryName).request().delete(RemoveRepositoryRequest.class);
        return this.waitUntilJobFinished(request);
    }

    @Override
    public CreateProjectRequest createProject(String repositoryName, ProjectRequest project) {
        log.info("Creating project '{}' in repository '{}'", (Object)project.getName(), (Object)repositoryName);
        CreateProjectRequest request = (CreateProjectRequest)this.target.path("repositories/{repositoryName}/projects").resolveTemplate("repositoryName", (Object)repositoryName).request().post(this.createEntity(project), CreateProjectRequest.class);
        return this.waitUntilJobFinished(request, 60);
    }

    @Override
    public DeleteProjectRequest deleteProject(String repositoryName, String projectName) {
        log.info("Removing project '{}' from repository '{}'", (Object)projectName, (Object)repositoryName);
        DeleteProjectRequest request = (DeleteProjectRequest)this.target.path("repositories/{repositoryName}/projects/{projectName}").resolveTemplate("repositoryName", (Object)repositoryName).resolveTemplate("projectName", (Object)projectName).request().delete(DeleteProjectRequest.class);
        return this.waitUntilJobFinished(request, 60);
    }

    @Override
    public Collection<ProjectResponse> getProjects(String repositoryName) {
        log.info("Retrieving all projects from repository '{}'", (Object)repositoryName);
        return (Collection)this.target.path("repositories/{repositoryName}/projects").resolveTemplate("repositoryName", (Object)repositoryName).request().get((GenericType)new GenericType<Collection<ProjectResponse>>(){});
    }

    @Override
    public Collection<OrganizationalUnit> getOrganizationalUnits() {
        log.info("Getting all organizational units");
        return (Collection)this.target.path("organizationalunits").request().get((GenericType)new GenericType<Collection<OrganizationalUnit>>(){});
    }

    @Override
    public CreateOrganizationalUnitRequest createOrganizationalUnit(OrganizationalUnit orgUnit) {
        log.info("Creating organizational unit '{}' ", (Object)orgUnit.getName());
        CreateOrganizationalUnitRequest request = (CreateOrganizationalUnitRequest)this.target.path("organizationalunits").request().post(this.createEntity(orgUnit), CreateOrganizationalUnitRequest.class);
        return this.waitUntilJobFinished(request);
    }

    @Override
    public OrganizationalUnit getOrganizationalUnit(String orgUnitName) {
        log.info("Getting organizational unit '{}'", (Object)orgUnitName);
        return (OrganizationalUnit)this.target.path("organizationalunits/{orgUnitName}").resolveTemplate("orgUnitName", (Object)orgUnitName).request().get(OrganizationalUnit.class);
    }

    @Override
    public UpdateOrganizationalUnitRequest updateOrganizationalUnit(String name, UpdateOrganizationalUnit orgUnit) {
        log.info("Updating organizational unit '{}'", (Object)name);
        UpdateOrganizationalUnitRequest request = (UpdateOrganizationalUnitRequest)this.target.path("organizationalunits/{orgUnitName}").resolveTemplate("orgUnitName", (Object)name).request().post(this.createEntity(orgUnit), UpdateOrganizationalUnitRequest.class);
        return this.waitUntilJobFinished(request);
    }

    @Override
    public RemoveOrganizationalUnitRequest deleteOrganizationalUnit(String name) {
        log.info("Deleting organizational unit '{}'", (Object)name);
        RemoveOrganizationalUnitRequest request = (RemoveOrganizationalUnitRequest)this.target.path("organizationalunits/{orgUnitName}").resolveTemplate("orgUnitName", (Object)name).request().delete(RemoveOrganizationalUnitRequest.class);
        return this.waitUntilJobFinished(request);
    }

    @Override
    public AddRepositoryToOrganizationalUnitRequest addRepositoryToOrganizationalUnit(String orgUnitName, String repositoryName) {
        log.info("Adding repository '{}' to organizational unit '{}'", (Object)repositoryName, (Object)orgUnitName);
        AddRepositoryToOrganizationalUnitRequest request = (AddRepositoryToOrganizationalUnitRequest)this.target.path("organizationalunits/{orgUnitName}/repositories/{repositoryName}").resolveTemplate("orgUnitName", (Object)orgUnitName).resolveTemplate("repositoryName", (Object)repositoryName).request().post(this.createEntity(""), AddRepositoryToOrganizationalUnitRequest.class);
        return this.waitUntilJobFinished(request);
    }

    @Override
    public RemoveRepositoryFromOrganizationalUnitRequest removeRepositoryFromOrganizationalUnit(String orgUnitName, String repositoryName) {
        log.info("Removing repository '{}' from organizational unit '{}'", (Object)repositoryName, (Object)orgUnitName);
        RemoveRepositoryFromOrganizationalUnitRequest request = (RemoveRepositoryFromOrganizationalUnitRequest)this.target.path("organizationalunits/{orgUnitName}/repositories/{repositoryName}").resolveTemplate("orgUnitName", (Object)orgUnitName).resolveTemplate("repositoryName", (Object)repositoryName).request().delete(RemoveRepositoryFromOrganizationalUnitRequest.class);
        return this.waitUntilJobFinished(request);
    }

    private <T extends JobRequest> T postMavenRequest(String repositoryName, String projectName, String phase, Class<T> requestType) {
        return (T)((JobRequest)this.target.path("repositories/{repositoryName}/projects/{projectName}/maven/{phase}").resolveTemplate("repositoryName", (Object)repositoryName).resolveTemplate("projectName", (Object)projectName).resolveTemplate("phase", (Object)phase).request().post(this.createEntity(""), requestType));
    }

    @Override
    public CompileProjectRequest compileProject(String repositoryName, String projectName) {
        log.info("Compiling project '{}' from repository '{}'", (Object)projectName, (Object)repositoryName);
        CompileProjectRequest request = this.postMavenRequest(repositoryName, projectName, "compile", CompileProjectRequest.class);
        return this.waitUntilJobFinished(request, 60);
    }

    @Override
    public InstallProjectRequest installProject(String repositoryName, String projectName) {
        log.info("Installing project '{}' from repository '{}'", (Object)projectName, (Object)repositoryName);
        InstallProjectRequest request = this.postMavenRequest(repositoryName, projectName, "install", InstallProjectRequest.class);
        return this.waitUntilJobFinished(request, 60);
    }

    @Override
    public TestProjectRequest testProject(String repositoryName, String projectName) {
        log.info("Testing project '{}' from repository '{}'", (Object)projectName, (Object)repositoryName);
        TestProjectRequest request = this.postMavenRequest(repositoryName, projectName, "test", TestProjectRequest.class);
        return this.waitUntilJobFinished(request, 60);
    }

    @Override
    public DeployProjectRequest deployProject(String repositoryName, String projectName) {
        log.info("Deploying project '{}' from repository '{}'", (Object)projectName, (Object)repositoryName);
        DeployProjectRequest request = this.postMavenRequest(repositoryName, projectName, "deploy", DeployProjectRequest.class);
        return this.waitUntilJobFinished(request, 60);
    }

    private <T extends JobRequest> T waitUntilJobFinished(T request) {
        return this.waitUntilJobFinished(request, 10);
    }

    private <T extends JobRequest> T waitUntilJobFinished(T request, int seconds) {
        JobResult jobResult;
        if (this.async) {
            return request;
        }
        block4: while ((jobResult = this.getJob(request.getJobId())).getStatus() != JobStatus.SUCCESS && seconds-- > 0) {
            switch (jobResult.getStatus()) {
                case ACCEPTED: 
                case APPROVED: {
                    this.sleepForSecond();
                    continue block4;
                }
                case SUCCESS: {
                    return request;
                }
            }
            throw new NotSuccessException(jobResult);
        }
        if (jobResult.getStatus() != JobStatus.SUCCESS) {
            throw new NotSuccessException(jobResult);
        }
        return request;
    }

    private void sleepForSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private <T> Entity<T> createEntity(T body) {
        return Entity.entity(body, (MediaType)MEDIA_TYPE);
    }
}

