/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.security;

import org.guvnor.rest.client.RepositoryRequest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.wb.test.rest.AccessRestTestBase;
import org.kie.wb.test.rest.User;
import org.kie.wb.test.rest.client.WorkbenchClient;

@RunWith(value=Parameterized.class)
public class RepositoryAccessIntegrationTest
extends AccessRestTestBase {
    private static final String ORG_UNIT = "repositoryAccessTestOrgUnit";

    public RepositoryAccessIntegrationTest(User user) {
        super(user);
    }

    @BeforeClass
    public static void createOrganizationalUnit() {
        RepositoryAccessIntegrationTest.createOrganizationalUnit(ORG_UNIT);
    }

    @Test
    public void testCreateRepository() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("createRepositoryWith" + this.user.getUserName());
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("new");
        this.assertOperation(() -> this.roleClient.createOrCloneRepository(repository));
    }

    @Test
    public void testCloneRepository() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("cloneRepositoryWith" + this.user.getUserName());
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("clone");
        repository.setGitURL(RepositoryAccessIntegrationTest.getLocalGitRepositoryUrl());
        this.assertOperation(() -> this.roleClient.createOrCloneRepository(repository));
    }

    @Test
    public void testDeleteRepository() {
        String name = "deleteRepositoryWith" + this.user.getUserName();
        RepositoryAccessIntegrationTest.createNewRepository(ORG_UNIT, name);
        this.assertOperation(() -> this.roleClient.deleteRepository(name));
    }

    @Test
    public void testGetRepository() {
        String name = "getRepositoryWith" + this.user.getUserName();
        RepositoryAccessIntegrationTest.createNewRepository(ORG_UNIT, name);
        this.assertOperation(() -> this.roleClient.getRepository(name));
    }

    @Test
    public void testGetRepositories() {
        this.assertOperation(() -> ((WorkbenchClient)this.roleClient).getRepositories());
    }
}

