/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.functional;

import java.util.Collection;
import javax.ws.rs.NotFoundException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.DeleteProjectRequest;
import org.guvnor.rest.client.DeployProjectRequest;
import org.guvnor.rest.client.Entity;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.ProjectRequest;
import org.guvnor.rest.client.ProjectResponse;
import org.guvnor.rest.client.TestProjectRequest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.client.NotSuccessException;
import qa.tools.ikeeper.annotation.Jira;

public class ProjectIntegrationTest
extends RestTestBase {
    private static final String ORG_UNIT = "projectTestOrgUnit";
    private static final String REPOSITORY = "projectTestRepository";
    private static final String DESCRIPTION = "Testing project";
    private static final String GROUP_ID = "org.kie.wb.test";
    private static final String VERSION = "1.0.0";
    private static final String SNAPSHOT_VERSION = "1.0.0-SNAPSHOT";
    private static final String DEFAULT_VERSION = "1.0";

    @BeforeClass
    public static void createRepository() {
        ProjectIntegrationTest.createOrganizationalUnit(ORG_UNIT);
        ProjectIntegrationTest.createNewRepository(ORG_UNIT, REPOSITORY);
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testCreateProjectWithoutName() {
        ProjectRequest project = new ProjectRequest();
        project.setGroupId(GROUP_ID);
        project.setVersion(VERSION);
        try {
            client.createProject(REPOSITORY, project);
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
            Assertions.assertThat((String)ex.getJobResult().getResult()).contains(new CharSequence[]{"name"});
        }
    }

    @Test
    public void testCreateProjectMinimal() {
        this.createProject("minimalProject", null, null, null);
    }

    @Test
    public void testCreateProjectWithDescription() {
        this.createProject("projectWithDescription", DESCRIPTION, null, null);
    }

    @Test
    public void testCreateProjectWithGroupId() {
        this.createProject("projectWithGroupId", null, GROUP_ID, null);
    }

    @Test
    public void testCreateProjectWithVersion() {
        this.createProject("projectWithoutVersion", null, null, VERSION);
    }

    @Jira(value={"GUVNOR-2542"})
    @Test(expected=NotFoundException.class)
    public void testDeleteNotExistingProject() {
        try {
            client.deleteProject(REPOSITORY, "notExistingProject");
        }
        catch (NotSuccessException ex) {
            System.out.println(ex.getJobResult().getStatus() + ": " + ex.getJobResult().getResult());
        }
    }

    @Test
    public void testDeleteProject() {
        String name = "projectToBeDeleted";
        this.createProject(name, null, null, null);
        DeleteProjectRequest request = client.deleteProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
        ProjectResponse project = this.getProjectByName(name);
        Assertions.assertThat((Object)project).isNull();
    }

    @Test
    public void testGetProjects() {
        String name = "oneOfManyProjects";
        this.createProject(name, null, null, null);
        Collection projects = client.getProjects(REPOSITORY);
        Assertions.assertThat((Iterable)projects).extracting(Entity::getName).contains((Object[])new String[]{name});
    }

    @Test
    public void testCompileProject() {
        String name = "projectToBeCompiled";
        this.createProject(name, null, null, null);
        CompileProjectRequest request = client.compileProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
    }

    @Test
    public void testTestProject() {
        String name = "projectToBeTested";
        this.createProject(name, null, null, null);
        TestProjectRequest request = client.testProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
    }

    @Test
    public void testInstallProject() {
        String name = "projectToBeInstalled" + Math.random();
        this.createProject(name, null, null, null);
        InstallProjectRequest request = client.installProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
    }

    @Test
    public void testInstallProjectTwice() {
        String name = "projectToBeInstalledTwice" + Math.random();
        this.createProject(name, null, null, VERSION);
        InstallProjectRequest request = client.installProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
        try {
            client.installProject(REPOSITORY, name);
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.DUPLICATE_RESOURCE);
        }
    }

    @Test
    public void testInstallProjectSnapshotTwice() {
        String name = "projectSnapshotToBeInstalledTwice" + Math.random();
        this.createProject(name, null, null, SNAPSHOT_VERSION);
        InstallProjectRequest request = client.installProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
        request = client.installProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
    }

    @Test
    public void testDeployProject() {
        String name = "projectToBeDeployed" + Math.random();
        this.createProject(name, null, null, null);
        DeployProjectRequest request = client.deployProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
    }

    @Test
    public void testDeployProjectTwice() {
        String name = "projectToBeDeployedTwice" + Math.random();
        this.createProject(name, null, null, VERSION);
        DeployProjectRequest request = client.deployProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
        try {
            client.deployProject(REPOSITORY, name);
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.DUPLICATE_RESOURCE);
        }
    }

    @Test
    public void testDeployProjectSnapshotTwice() {
        String name = "projectSnapshotToBeDeployedTwice" + Math.random();
        this.createProject(name, null, null, SNAPSHOT_VERSION);
        DeployProjectRequest request = client.deployProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
        request = client.deployProject(REPOSITORY, name);
        Assertions.assertThat((String)request.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        Assertions.assertThat((String)request.getProjectName()).isEqualTo((Object)name);
    }

    private void createProject(String name, String description, String groupId, String version) {
        ProjectRequest project = new ProjectRequest();
        project.setName(name);
        project.setDescription(description);
        project.setGroupId(groupId);
        project.setVersion(version);
        CreateProjectRequest request = client.createProject(REPOSITORY, project);
        this.assertCreateProjectRequest(request, project);
        this.assertProjectExists(project);
    }

    private void assertCreateProjectRequest(CreateProjectRequest actual, ProjectRequest expected) {
        SoftAssertions assertions = new SoftAssertions();
        assertions.assertThat(actual.getRepositoryName()).isEqualTo((Object)REPOSITORY);
        assertions.assertThat(actual.getProjectName()).isEqualTo((Object)expected.getName());
        assertions.assertThat(actual.getDescription()).isEqualTo((Object)expected.getDescription());
        assertions.assertThat(actual.getProjectGroupId()).isEqualTo((Object)expected.getGroupId());
        assertions.assertThat(actual.getProjectVersion()).isEqualTo((Object)expected.getVersion());
        assertions.assertAll();
    }

    private void assertProjectExists(ProjectRequest projectRequest) {
        ProjectResponse projectResponse = this.getProjectByName(projectRequest.getName());
        SoftAssertions assertions = new SoftAssertions();
        assertions.assertThat(projectResponse.getName()).isEqualTo((Object)projectRequest.getName());
        assertions.assertThat(projectResponse.getDescription()).isEqualTo((Object)projectRequest.getDescription());
        assertions.assertThat(projectResponse.getGroupId()).isEqualTo((Object)(projectRequest.getGroupId() == null ? projectRequest.getName() : projectRequest.getGroupId()));
        assertions.assertThat(projectResponse.getVersion()).isEqualTo((Object)(projectRequest.getVersion() == null ? DEFAULT_VERSION : projectRequest.getVersion()));
        assertions.assertAll();
    }

    private ProjectResponse getProjectByName(String name) {
        Collection projects = client.getProjects(REPOSITORY);
        return projects.parallelStream().filter(projectResponse -> projectResponse.getName().equals(name)).findAny().orElse(null);
    }
}

