/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.security;

import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.UpdateOrganizationalUnit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.wb.test.rest.AccessRestTestBase;
import org.kie.wb.test.rest.User;
import org.kie.wb.test.rest.client.WorkbenchClient;

@RunWith(value=Parameterized.class)
public class OrganizationalUnitAccessIntegrationTest
extends AccessRestTestBase {
    public OrganizationalUnitAccessIntegrationTest(User user) {
        super(user);
    }

    @Test
    public void testCreateOrganizationalUnit() {
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName("createOrgUnitWith" + this.user.getUserName());
        orgUnit.setOwner(USER_ID);
        this.assertOperation(() -> this.roleClient.createOrganizationalUnit(orgUnit));
    }

    @Test
    public void testUpdateOrganizationalUnit() {
        String name = "updateOrgUnitWith" + this.user.getUserName();
        OrganizationalUnitAccessIntegrationTest.createOrganizationalUnit(name);
        UpdateOrganizationalUnit updateOrgUnit = new UpdateOrganizationalUnit();
        updateOrgUnit.setOwner(this.user.getUserName());
        this.assertOperation(() -> this.roleClient.updateOrganizationalUnit(name, updateOrgUnit));
    }

    @Test
    public void testDeleteOrganizationalUnit() {
        String name = "deleteOrgUnitWith" + this.user.getUserName();
        OrganizationalUnitAccessIntegrationTest.createOrganizationalUnit(name);
        this.assertOperation(() -> this.roleClient.deleteOrganizationalUnit(name));
    }

    @Test
    public void testGetOrganizationalUnit() {
        String name = "getOrgUnitWith" + this.user.getUserName();
        OrganizationalUnitAccessIntegrationTest.createOrganizationalUnit(name);
        this.assertOperation(() -> this.roleClient.getOrganizationalUnit(name));
    }

    @Test
    public void testGetOrganizationalUnits() {
        this.assertOperation(() -> ((WorkbenchClient)this.roleClient).getOrganizationalUnits());
    }

    @Test
    public void testAddRepositoryToOrganizationalUnit() {
        String originOrgUnitName = "originAddRepoOrgUnitWith" + this.user.getUserName();
        OrganizationalUnitAccessIntegrationTest.createOrganizationalUnit(originOrgUnitName);
        String repoName = "addToOrgUnitRepoWith" + this.user.getUserName();
        OrganizationalUnitAccessIntegrationTest.createNewRepository(originOrgUnitName, repoName);
        String orgUnitName = "addRepoOrgUnitWith" + this.user.getUserName();
        OrganizationalUnitAccessIntegrationTest.createOrganizationalUnit(orgUnitName);
        this.assertOperation(() -> this.roleClient.addRepositoryToOrganizationalUnit(orgUnitName, repoName));
    }

    @Test
    public void testRemoveRepositoryFromOrganizationalUnit() {
        String orgUnitName = "originRemoveFromOrgUnitWith" + this.user.getUserName();
        OrganizationalUnitAccessIntegrationTest.createOrganizationalUnit(orgUnitName);
        String repoName = "removeFromOrgUnitRepoWith" + this.user.getUserName();
        OrganizationalUnitAccessIntegrationTest.createNewRepository(orgUnitName, repoName);
        this.assertOperation(() -> this.roleClient.removeRepositoryFromOrganizationalUnit(orgUnitName, repoName));
    }
}

