/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.Entity;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.RepositoryRequest;
import org.guvnor.rest.client.UpdateOrganizationalUnit;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.User;
import org.kie.wb.test.rest.client.NotSuccessException;
import qa.tools.ikeeper.annotation.Jira;

public class OrganizationalUnitIntegrationTest
extends RestTestBase {
    private static final String DESCRIPTION = "Testing organizational unit";
    private static final String GROUP_ID = "org.kie.wb.test";
    private static final String OWNER = USER_ID;
    private static final String DESCRIPTION2 = "Modified testing organizational unit";
    private static final String GROUP_ID2 = "org.kie.wb.test.other";
    private static final String OWNER2 = User.NO_REST.getUserName();

    @Test
    public void testCreateEmptyName() {
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setOwner(OWNER);
        try {
            client.createOrganizationalUnit(orgUnit);
            Assertions.fail((String)"NotSuccessException should have been thrown");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
            Assertions.assertThat((String)ex.getJobResult().getResult()).contains(new CharSequence[]{"name"});
        }
    }

    @Test
    public void testCreateEmptyOwner() {
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName("emptyOwnerOrgUnit");
        try {
            client.createOrganizationalUnit(orgUnit);
            Assertions.fail((String)"NotSuccessException should have been thrown");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
            Assertions.assertThat((String)ex.getJobResult().getResult()).contains(new CharSequence[]{"owner"});
        }
    }

    @Test
    public void testCreateMinimal() {
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName("minimalOrgUnit");
        orgUnit.setOwner(OWNER);
        this.testCreate(orgUnit);
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testCreateWithDescription() {
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName("orgUnitWithDescription");
        orgUnit.setOwner(OWNER);
        orgUnit.setDescription(DESCRIPTION);
        this.testCreate(orgUnit);
    }

    @Test
    public void testCreateWithGroupId() {
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName("orgUnitWithGroupId");
        orgUnit.setOwner(OWNER);
        orgUnit.setDefaultGroupId(GROUP_ID);
        this.testCreate(orgUnit);
    }

    @Test
    public void testCreateWithRepositories() {
        String originOrgUnitName = "originRepositoryOrgUnit";
        this.prepareOrganizationalUnit("originRepositoryOrgUnit");
        String repositoryName1 = "orgUnitRepository1";
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("orgUnitRepository1");
        repository.setOrganizationalUnitName("originRepositoryOrgUnit");
        repository.setRequestType("new");
        client.createOrCloneRepository(repository);
        String repositoryName2 = "orgUnitRepository2";
        RepositoryRequest repository2 = new RepositoryRequest();
        repository2.setName("orgUnitRepository2");
        repository2.setOrganizationalUnitName("originRepositoryOrgUnit");
        repository2.setRequestType("new");
        client.createOrCloneRepository(repository2);
        ArrayList<String> repositories = new ArrayList<String>();
        repositories.add("orgUnitRepository1");
        repositories.add("orgUnitRepository2");
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName("orgUnitWithRepositories");
        orgUnit.setOwner(OWNER);
        orgUnit.setRepositories(repositories);
        this.testCreate(orgUnit);
    }

    @Test(expected=NotFoundException.class)
    public void testUpdateNotExisting() {
        UpdateOrganizationalUnit updateOrgUnit = new UpdateOrganizationalUnit();
        updateOrgUnit.setOwner(OWNER2);
        client.updateOrganizationalUnit("notExistingOrgUnit", updateOrgUnit);
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testUpdateName() {
        String oldName = "nameToBeChangedOrgUnit";
        String newName = "nameChangedOrgUnit";
        this.prepareOrganizationalUnit(oldName);
        UpdateOrganizationalUnit updateOrgUnit = new UpdateOrganizationalUnit();
        updateOrgUnit.setName(newName);
        client.updateOrganizationalUnit(oldName, updateOrgUnit);
        OrganizationalUnit orgUnit = client.getOrganizationalUnit(newName);
        Assertions.assertThat((Object)orgUnit).isNotNull();
    }

    @Test
    public void testUpdateOwner() {
        String name = "ownerChangeOrgUnit";
        this.prepareOrganizationalUnit(name);
        UpdateOrganizationalUnit updateOrgUnit = new UpdateOrganizationalUnit();
        updateOrgUnit.setOwner(OWNER2);
        client.updateOrganizationalUnit(name, updateOrgUnit);
        OrganizationalUnit orgUnit = client.getOrganizationalUnit(name);
        Assertions.assertThat((String)orgUnit.getOwner()).isEqualTo((Object)OWNER2);
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testUpdateDescription() {
        String name = "descriptionChangeOrgUnit";
        this.prepareOrganizationalUnit(name);
        UpdateOrganizationalUnit updateOrgUnit = new UpdateOrganizationalUnit();
        updateOrgUnit.setDescription(DESCRIPTION2);
        client.updateOrganizationalUnit(name, updateOrgUnit);
        OrganizationalUnit orgUnit = client.getOrganizationalUnit(name);
        Assertions.assertThat((String)orgUnit.getDescription()).isEqualTo((Object)DESCRIPTION2);
    }

    @Test
    public void testUpdateGroupId() {
        String name = "groupIdChangeOrgUnit";
        this.prepareOrganizationalUnit(name);
        UpdateOrganizationalUnit updateOrgUnit = new UpdateOrganizationalUnit();
        updateOrgUnit.setDefaultGroupId(GROUP_ID2);
        client.updateOrganizationalUnit(name, updateOrgUnit);
        OrganizationalUnit orgUnit = client.getOrganizationalUnit(name);
        Assertions.assertThat((String)orgUnit.getDefaultGroupId()).isEqualTo((Object)GROUP_ID2);
    }

    @Test(expected=NotFoundException.class)
    public void testDeleteNotExisting() {
        client.deleteOrganizationalUnit("notExistingOrgUnit");
    }

    @Test
    public void testDeleteExisting() {
        String name = "orgUnitToBeDeleted";
        this.prepareOrganizationalUnit(name);
        client.deleteOrganizationalUnit(name);
        try {
            client.getOrganizationalUnit(name);
            Assertions.fail((String)"Organizational unit should have been deleted");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test(expected=NotFoundException.class)
    public void testGetNotExisting() {
        client.getOrganizationalUnit("notExistingOrgUnit");
    }

    @Test
    public void testGetExisting() {
        String name = "getExistingOrgUnit";
        this.prepareOrganizationalUnit(name);
        OrganizationalUnit orgUnit = client.getOrganizationalUnit(name);
        Assertions.assertThat((String)orgUnit.getName()).isEqualTo((Object)name);
    }

    @Test
    public void testGetAll() {
        String name = "oneOfManyOrgUnit";
        this.prepareOrganizationalUnit(name);
        Collection orgUnits = client.getOrganizationalUnits();
        for (OrganizationalUnit orgUnit : orgUnits) {
            System.out.println(orgUnit);
        }
        Assertions.assertThat((Iterable)orgUnits).extracting(Entity::getName).contains((Object[])new String[]{name});
    }

    @Test
    public void testAddRepositoryToNotExistingOrganizationalUnit() {
        String orgUnitName = "addToNotExistingOrgUnit";
        this.prepareOrganizationalUnit(orgUnitName);
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("addToNotExistingOrgUnitRepo");
        repository.setOrganizationalUnitName(orgUnitName);
        repository.setRequestType("new");
        client.createOrCloneRepository(repository);
        try {
            client.addRepositoryToOrganizationalUnit("notExistingOrgUnit", repository.getName());
            Assertions.fail((String)"The operation should have failed because organizational unit does not exist");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAddNotExistingRepositoryToOrganizationalUnit() {
        String orgUnitName = "addToNotExistingRepoOrgUnit";
        this.prepareOrganizationalUnit(orgUnitName);
        try {
            client.addRepositoryToOrganizationalUnit(orgUnitName, "notExistingRepo");
            Assertions.fail((String)"The operation should have failed because repository does not exist");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testAddRepositoryToOrganizationalUnitAlreadyAdded() {
        String orgUnitName = "alreadyAddedRepoOrgUnit";
        this.prepareOrganizationalUnit(orgUnitName);
        String repoName = "alreadyAddedRepo";
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName(repoName);
        repository.setOrganizationalUnitName(orgUnitName);
        repository.setRequestType("new");
        client.createOrCloneRepository(repository);
        try {
            client.addRepositoryToOrganizationalUnit(orgUnitName, repoName);
            Assertions.fail((String)"The operation should not have succeeded");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
        }
    }

    @Test
    public void testAddRepositoryToOrganizationalUnit() {
        String originOrgUnitName = "originAddRepoOrgUnit";
        this.prepareOrganizationalUnit(originOrgUnitName);
        String repoName = "addToOrgUnitRepo";
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName(repoName);
        repository.setOrganizationalUnitName(originOrgUnitName);
        repository.setRequestType("new");
        client.createOrCloneRepository(repository);
        String orgUnitName = "addRepoOrgUnit";
        this.prepareOrganizationalUnit(orgUnitName);
        client.addRepositoryToOrganizationalUnit(orgUnitName, repoName);
        OrganizationalUnit orgUnit = client.getOrganizationalUnit(orgUnitName);
        Assertions.assertThat((List)orgUnit.getRepositories()).contains((Object[])new String[]{repoName});
    }

    @Test
    public void testRemoveRepositoryFromNotExistingOrganizationalUnit() {
        String orgUnitName = "removeFromNotExistingOrgUnit";
        this.prepareOrganizationalUnit(orgUnitName);
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("removeFromNotExistingOrgUnitRepo");
        repository.setOrganizationalUnitName(orgUnitName);
        repository.setRequestType("new");
        client.createOrCloneRepository(repository);
        try {
            client.removeRepositoryFromOrganizationalUnit("notExistingOrgUnit", repository.getName());
            Assertions.fail((String)"The operation should have failed because organizational unit does not exist");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveNotExistingRepositoryFromOrganizationalUnit() {
        String orgUnitName = "removeFromNotExistingRepoOrgUnit";
        this.prepareOrganizationalUnit(orgUnitName);
        try {
            client.addRepositoryToOrganizationalUnit(orgUnitName, "notExistingRepo");
            Assertions.fail((String)"The operation should have failed because repository does not exist");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testRemoveNotAddedRepositoryFromOrganizationalUnit() {
        String originOrgUnitName = "originRemoveFromNotAddedOrgUnit";
        this.prepareOrganizationalUnit(originOrgUnitName);
        String repoName = "removeFromNotAddedRepo";
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName(repoName);
        repository.setOrganizationalUnitName(originOrgUnitName);
        repository.setRequestType("new");
        client.createOrCloneRepository(repository);
        String orgUnitName = "removeFromNotAddedOrgUnit";
        this.prepareOrganizationalUnit(orgUnitName);
        try {
            client.removeRepositoryFromOrganizationalUnit(orgUnitName, repoName);
            Assertions.fail((String)"Operation should have failed");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
        }
    }

    @Test
    public void testRemoveRepositoryFromOrganizationalUnit() {
        String orgUnitName = "originRemoveFromOrgUnit";
        this.prepareOrganizationalUnit(orgUnitName);
        String repoName = "removeFromOrgUnitRepo";
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName(repoName);
        repository.setOrganizationalUnitName(orgUnitName);
        repository.setRequestType("new");
        client.createOrCloneRepository(repository);
        client.removeRepositoryFromOrganizationalUnit(orgUnitName, repoName);
        OrganizationalUnit orgUnit = client.getOrganizationalUnit(orgUnitName);
        Assertions.assertThat((List)orgUnit.getRepositories()).doesNotContain((Object[])new String[]{repoName});
    }

    private OrganizationalUnit prepareOrganizationalUnit(String name) {
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName(name);
        orgUnit.setOwner(OWNER);
        orgUnit.setDescription(DESCRIPTION);
        orgUnit.setDefaultGroupId(GROUP_ID);
        client.createOrganizationalUnit(orgUnit);
        OrganizationalUnit storedOrgUnit = client.getOrganizationalUnit(name);
        Assertions.assertThat((Object)storedOrgUnit).isNotNull();
        return orgUnit;
    }

    private void assertCreateOrganizationalUnitRequest(CreateOrganizationalUnitRequest request, OrganizationalUnit orgUnit) {
        SoftAssertions assertions = new SoftAssertions();
        assertions.assertThat(request.getOrganizationalUnitName()).isEqualTo((Object)orgUnit.getName());
        assertions.assertThat(request.getDescription()).isEqualTo((Object)orgUnit.getDescription());
        assertions.assertThat(request.getOwner()).isEqualTo((Object)orgUnit.getOwner());
        assertions.assertThat(request.getDefaultGroupId()).isEqualTo((Object)orgUnit.getDefaultGroupId());
        if (orgUnit.getRepositories() != null) {
            assertions.assertThat(request.getRepositories()).containsOnly((Object[])orgUnit.getRepositories().toArray(new String[0]));
        }
        assertions.assertAll();
    }

    private void assertOrganizationalUnit(OrganizationalUnit actual, OrganizationalUnit expected) {
        if (expected.getDefaultGroupId() == null) {
            expected.setDefaultGroupId(expected.getName());
        }
        SoftAssertions assertions = new SoftAssertions();
        assertions.assertThat(actual.getName()).isEqualTo((Object)expected.getName());
        assertions.assertThat(actual.getDescription()).isEqualTo((Object)expected.getDescription());
        assertions.assertThat(actual.getOwner()).isEqualTo((Object)expected.getOwner());
        assertions.assertThat(actual.getDefaultGroupId()).isEqualTo((Object)expected.getDefaultGroupId());
        if (expected.getRepositories() != null) {
            assertions.assertThat(actual.getRepositories()).containsOnly((Object[])expected.getRepositories().toArray(new String[0]));
        }
        assertions.assertAll();
    }

    private void testCreate(OrganizationalUnit organizationalUnit) {
        CreateOrganizationalUnitRequest request = client.createOrganizationalUnit(organizationalUnit);
        this.assertCreateOrganizationalUnitRequest(request, organizationalUnit);
        OrganizationalUnit orgUnit = client.getOrganizationalUnit(organizationalUnit.getName());
        this.assertOrganizationalUnit(orgUnit, organizationalUnit);
    }
}

