/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.functional;

import org.assertj.core.api.Assertions;
import org.guvnor.rest.client.CreateOrganizationalUnitRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.RepositoryRequest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.client.RestWorkbenchClient;
import org.kie.wb.test.rest.client.WorkbenchClient;

public class JobIntegrationTest
extends RestTestBase {
    private static final String ORG_UNIT = "jobTestOrgUnit";
    protected static WorkbenchClient asyncClient;

    @BeforeClass
    public static void setUp() {
        JobIntegrationTest.deleteAllRepositories();
        JobIntegrationTest.deleteAllOrganizationalUnits();
        JobIntegrationTest.createOrganizationalUnit(ORG_UNIT);
        asyncClient = RestWorkbenchClient.createAsyncWorkbenchClient((String)URL, (String)USER_ID, (String)PASSWORD);
    }

    private JobRequest cloneRepositoryAsync(String name) {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName(name);
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("clone");
        repository.setGitURL(JobIntegrationTest.getLocalGitRepositoryUrl());
        return asyncClient.createOrCloneRepository(repository);
    }

    @Test
    public void testGet() {
        CreateOrganizationalUnitRequest jobRequest = JobIntegrationTest.createOrganizationalUnit("getJobOrgUnit");
        JobResult jobResult = client.getJob(jobRequest.getJobId());
        Assertions.assertThat((Comparable)jobResult.getStatus()).isNotEqualTo((Object)JobStatus.GONE);
    }

    @Test
    public void testDelete() {
        JobRequest jobRequest = this.cloneRepositoryAsync("deleteJobRepository");
        JobResult jobResult = client.getJob(jobRequest.getJobId());
        Assertions.assertThat((Comparable)jobResult.getStatus()).isNotEqualTo((Object)JobStatus.GONE);
        jobResult = client.deleteJob(jobRequest.getJobId());
        Assertions.assertThat((Comparable)jobResult.getStatus()).isEqualTo((Object)JobStatus.GONE);
        jobResult = client.getJob(jobRequest.getJobId());
        Assertions.assertThat((Comparable)jobResult.getStatus()).isEqualTo((Object)JobStatus.GONE);
    }

    @Test
    public void testDeleteNotExisting() {
        JobResult jobResult = client.deleteJob("notExistingJob");
        Assertions.assertThat((Comparable)jobResult.getStatus()).isEqualTo((Object)JobStatus.GONE);
    }

    @Test
    public void testGetNotExisting() {
        JobResult jobResult = client.getJob("notExistingJob");
        Assertions.assertThat((Comparable)jobResult.getStatus()).isEqualTo((Object)JobStatus.GONE);
    }
}

