/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.functional;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.guvnor.rest.client.CloneProjectJobRequest;
import org.guvnor.rest.client.CloneProjectRequest;
import org.guvnor.rest.client.JobStatus;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.client.NotSuccessException;
import org.kie.wb.test.rest.functional.Utils;
import qa.tools.ikeeper.annotation.Jira;

public class RepositoryIntegrationTest
extends RestTestBase {
    private static final String SPACE = "testSpace";

    @BeforeClass
    public static void createSpace() {
        RepositoryIntegrationTest.createSpace(SPACE);
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testCloneRepositoryNotExistingUrl() {
        CloneProjectRequest cloneProjectRequest = new CloneProjectRequest();
        cloneProjectRequest.setName("clonedRepoWithNotExistingUrl");
        cloneProjectRequest.setGitURL(RepositoryIntegrationTest.getLocalGitRepositoryUrl() + "xyz");
        try {
            client.cloneRepository(SPACE, cloneProjectRequest);
            Assertions.fail((String)"Operation should fail because of not valid Git URL");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
        }
    }

    @Test
    public void testCloneRepositoryLocalFileSystem() {
        CloneProjectRequest cloneProjectRequest = new CloneProjectRequest();
        cloneProjectRequest.setName("clonedRemoteRepo");
        cloneProjectRequest.setGitURL(RepositoryIntegrationTest.getLocalGitRepositoryUrl());
        CloneProjectJobRequest request = client.cloneRepository(SPACE, cloneProjectRequest);
        Assertions.assertThat((Object)request).isNotNull();
        this.assertRepositoryRequest(request.getCloneProjectRequest(), cloneProjectRequest);
        List projects = client.getSpace(SPACE).getProjects();
        Assertions.assertThat(Utils.getProjectNames(projects)).contains((Object[])new String[]{cloneProjectRequest.getName()});
    }

    @Test
    public void testCloneRepositoryInternal() {
        String originalRepo = "repoToBeCloned";
        RepositoryIntegrationTest.createNewProject(SPACE, "repoToBeCloned", "org.team", "1.1.0");
        CloneProjectRequest cloneProjectRequest = new CloneProjectRequest();
        cloneProjectRequest.setName("clonedInternalRepo");
        cloneProjectRequest.setGitURL("git://localhost:" + GIT_PORT + "/" + SPACE + "/" + "repoToBeCloned");
        CloneProjectJobRequest request = client.cloneRepository(SPACE, cloneProjectRequest);
        Assertions.assertThat((Object)request).isNotNull();
        this.assertRepositoryRequest(request.getCloneProjectRequest(), cloneProjectRequest);
        List projects = client.getSpace(SPACE).getProjects();
        Assertions.assertThat(Utils.getProjectNames(projects)).contains((Object[])new String[]{"clonedRemoteRepo", "repoToBeCloned", "repoToBeCloned"});
    }

    private void assertRepositoryRequest(CloneProjectRequest actual, CloneProjectRequest expected) {
        Assertions.assertThat((Object)actual).isNotNull();
        SoftAssertions assertions = new SoftAssertions();
        assertions.assertThat(actual.getName()).isEqualTo((Object)expected.getName());
        assertions.assertThat(actual.getDescription()).isEqualTo((Object)expected.getDescription());
        assertions.assertThat(actual.getUserName()).isEqualTo((Object)expected.getUserName());
        assertions.assertThat(actual.getPassword()).isEqualTo((Object)expected.getPassword());
        assertions.assertThat(actual.getGitURL()).isEqualTo((Object)expected.getGitURL());
        assertions.assertAll();
    }
}

