/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.quarkus;

import graphql.GraphQL;
import io.quarkus.vertx.web.Route;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext;
import io.vertx.ext.web.handler.graphql.GraphQLHandler;
import io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Synchronization;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.Transactional;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.kogito.app.audit.api.DataAuditQuery;
import org.kie.kogito.app.audit.api.DataAuditQueryService;
import org.kie.kogito.app.audit.api.DataAuditStoreProxyService;
import org.kie.kogito.app.audit.graphql.GraphQLSchemaBuild;
import org.kie.kogito.app.audit.graphql.GraphQLSchemaManager;
import org.kie.kogito.app.audit.spi.DataAuditContextFactory;

@ApplicationScoped
@Transactional
public class GraphQLDataAuditRouter {
    GraphQL graphQL;
    GraphQLHandler graphQLHandler;
    @Inject
    DataAuditContextFactory dataAuditContextFactory;
    private DataAuditQueryService dataAuditQueryService;
    private DataAuditStoreProxyService dataAuditStoreProxyService;
    @Inject
    TransactionSynchronizationRegistry registry;

    @PostConstruct
    public void init() {
        this.dataAuditStoreProxyService = DataAuditStoreProxyService.newAuditStoreService();
        this.dataAuditQueryService = DataAuditQueryService.newAuditQuerySerice();
        Map<String, String> queries = this.dataAuditStoreProxyService.findQueries(this.dataAuditContextFactory.newDataAuditContext()).stream().collect(Collectors.toMap(DataAuditQuery::getIdentifier, DataAuditQuery::getGraphQLDefinition));
        GraphQLSchemaManager.graphQLSchemaManagerInstance().init(this.dataAuditContextFactory.newDataAuditContext(), queries);
        this.graphQLHandler = GraphQLHandler.create((GraphQL)this.dataAuditQueryService.getGraphQL(), (GraphQLHandlerOptions)new GraphQLHandlerOptions());
    }

    @Route(path="/data-audit/q", type=Route.HandlerType.BLOCKING, order=2, methods={Route.HttpMethod.POST})
    public void blockingGraphQLHandlerPost(RoutingContext rc) {
        this.graphQLHandler.beforeExecute(this::beforeExecuteHTTP).handle((Object)rc);
    }

    @Route(path="/data-audit/r", type=Route.HandlerType.BLOCKING, order=2, methods={Route.HttpMethod.POST})
    public void blockingRegistryHandlerPost(RoutingContext rc) {
        try {
            JsonObject jsonObject = rc.body().asJsonObject();
            DataAuditQuery dataAuditQuery = new DataAuditQuery();
            dataAuditQuery.setIdentifier(jsonObject.getString("identifier"));
            dataAuditQuery.setGraphQLDefinition(jsonObject.getString("graphQLDefinition"));
            dataAuditQuery.setQuery(jsonObject.getString("query"));
            this.dataAuditStoreProxyService.storeQuery(this.dataAuditContextFactory.newDataAuditContext(), dataAuditQuery);
            final GraphQLSchemaBuild build = GraphQLSchemaManager.graphQLSchemaManagerInstance().devireNewDataAuditQuerySchema(this.dataAuditContextFactory.newDataAuditContext(), dataAuditQuery);
            this.registry.registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    if (status != 3) {
                        return;
                    }
                    GraphQLSchemaManager.graphQLSchemaManagerInstance().setGraphQLSchemaBuild(build);
                    GraphQLDataAuditRouter.this.graphQLHandler = GraphQLHandler.create((GraphQL)GraphQLDataAuditRouter.this.dataAuditQueryService.getGraphQL(), (GraphQLHandlerOptions)new GraphQLHandlerOptions());
                }
            });
            rc.response().setStatusCode(200).end();
        }
        catch (Exception e) {
            rc.response().setStatusCode(400).end(e.getLocalizedMessage());
            throw e;
        }
    }

    @Route(path="/data-audit/r", type=Route.HandlerType.BLOCKING, order=2, methods={Route.HttpMethod.GET})
    public void blockingRegistryHandlerGet(RoutingContext rc) {
        rc.response().setStatusCode(200).end(GraphQLSchemaManager.graphQLSchemaManagerInstance().getGraphQLSchemaDefinition());
    }

    private void beforeExecuteHTTP(ExecutionInputBuilderWithContext<RoutingContext> config) {
        config.builder().localContext((Object)this.dataAuditContextFactory.newDataAuditContext());
    }
}

