/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.quarkus;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.Collection;
import org.kie.kogito.app.audit.api.DataAuditStoreProxyService;
import org.kie.kogito.app.audit.spi.DataAuditContextFactory;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.event.job.JobInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class QuarkusDataAuditEventPublisher
implements EventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuarkusDataAuditEventPublisher.class);
    private DataAuditStoreProxyService proxy = DataAuditStoreProxyService.newAuditStoreService();
    @Inject
    DataAuditContextFactory dataAuditContextFactory;

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void publish(Collection<DataEvent<?>> events) {
        events.forEach(this::publish);
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void publish(DataEvent<?> event) {
        if (event instanceof ProcessInstanceDataEvent) {
            LOGGER.debug("Processing process instance event {}", event);
            this.proxy.storeProcessInstanceDataEvent(this.dataAuditContextFactory.newDataAuditContext(), (ProcessInstanceDataEvent)event);
            return;
        }
        if (event instanceof UserTaskInstanceDataEvent) {
            LOGGER.debug("Processing user task instacne event {}", event);
            this.proxy.storeUserTaskInstanceDataEvent(this.dataAuditContextFactory.newDataAuditContext(), (UserTaskInstanceDataEvent)event);
            return;
        }
        if (event instanceof JobInstanceDataEvent) {
            LOGGER.debug("Processing job instance event {}", event);
            this.proxy.storeJobDataEvent(this.dataAuditContextFactory.newDataAuditContext(), (JobInstanceDataEvent)event);
            return;
        }
        LOGGER.info("Discard event {} as class {} is not supported by this", event, (Object)event.getClass().getName());
    }
}

