/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceErrorDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeDataEvent;
import org.kie.kogito.event.process.ProcessInstanceSLADataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateDataEvent;
import org.kie.kogito.event.process.ProcessInstanceVariableDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonProcessInstanceDataEventDeserializer
extends StdDeserializer<ProcessInstanceDataEvent<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonProcessInstanceDataEventDeserializer.class);
    private static final long serialVersionUID = 6152014726577574241L;

    public JsonProcessInstanceDataEventDeserializer() {
        this(null);
    }

    public JsonProcessInstanceDataEventDeserializer(Class<?> vc) {
        super(vc);
    }

    public ProcessInstanceDataEvent<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String type;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        LOGGER.debug("Deserialize process instance data event: {}", (Object)node);
        switch (type = node.get("type").asText()) {
            case "ProcessInstanceErrorDataEvent": {
                return (ProcessInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, ProcessInstanceErrorDataEvent.class);
            }
            case "ProcessInstanceNodeDataEvent": {
                return (ProcessInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, ProcessInstanceNodeDataEvent.class);
            }
            case "ProcessInstanceSLADataEvent": {
                return (ProcessInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, ProcessInstanceSLADataEvent.class);
            }
            case "ProcessInstanceStateDataEvent": {
                return (ProcessInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, ProcessInstanceStateDataEvent.class);
            }
            case "ProcessInstanceVariableDataEvent": {
                return (ProcessInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, ProcessInstanceVariableDataEvent.class);
            }
        }
        LOGGER.warn("Unknown type {} in json data {}", (Object)type, (Object)node);
        return (ProcessInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, ProcessInstanceDataEvent.class);
    }
}

