/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDeadlineDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUserTaskInstanceDataEventDeserializer
extends StdDeserializer<UserTaskInstanceDataEvent<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUserTaskInstanceDataEventDeserializer.class);
    private static final long serialVersionUID = -6626663191296012306L;

    public JsonUserTaskInstanceDataEventDeserializer() {
        this(null);
    }

    public JsonUserTaskInstanceDataEventDeserializer(Class<?> vc) {
        super(vc);
    }

    public UserTaskInstanceDataEvent<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String type;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        LOGGER.debug("Deserialize user task instance data event: {}", (Object)node);
        switch (type = node.get("type").asText()) {
            case "UserTaskInstanceAssignmentDataEvent": {
                return (UserTaskInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, UserTaskInstanceAssignmentDataEvent.class);
            }
            case "UserTaskInstanceAttachmentDataEvent": {
                return (UserTaskInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, UserTaskInstanceAttachmentDataEvent.class);
            }
            case "UserTaskInstanceCommentDataEvent": {
                return (UserTaskInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, UserTaskInstanceCommentDataEvent.class);
            }
            case "UserTaskInstanceDeadlineDataEvent": {
                return (UserTaskInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, UserTaskInstanceDeadlineDataEvent.class);
            }
            case "UserTaskInstanceStateDataEvent": {
                return (UserTaskInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, UserTaskInstanceStateDataEvent.class);
            }
            case "UserTaskInstanceVariableDataEvent": {
                return (UserTaskInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, UserTaskInstanceVariableDataEvent.class);
            }
        }
        LOGGER.warn("Unknown type {} in json data {}", (Object)type, (Object)node);
        return (UserTaskInstanceDataEvent)jp.getCodec().treeToValue((TreeNode)node, UserTaskInstanceDataEvent.class);
    }
}

