/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.cloudevents.jackson.JsonFormat;
import org.kie.kogito.app.audit.json.JsonJobDataEventDeserializer;
import org.kie.kogito.app.audit.json.JsonProcessInstanceDataEventDeserializer;
import org.kie.kogito.app.audit.json.JsonUserTaskInstanceDataEventDeserializer;
import org.kie.kogito.event.job.JobInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;

public final class JsonUtils {
    private static final ObjectMapper MAPPER = JsonUtils.configure(new ObjectMapper());

    private JsonUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return MAPPER;
    }

    public static ObjectMapper configure(ObjectMapper objectMapper) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule((Module)JsonFormat.getCloudEventJacksonModule());
        objectMapper.registerModule((Module)new JavaTimeModule());
        SimpleModule module = new SimpleModule("Kogito Cloud Events");
        module.addDeserializer(ProcessInstanceDataEvent.class, (JsonDeserializer)new JsonProcessInstanceDataEventDeserializer());
        module.addDeserializer(UserTaskInstanceDataEvent.class, (JsonDeserializer)new JsonUserTaskInstanceDataEventDeserializer());
        module.addDeserializer(JobInstanceDataEvent.class, (JsonDeserializer)new JsonJobDataEventDeserializer());
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }
}

