/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kafka.common.serialization.Deserializer;
import org.kie.kogito.app.audit.json.JsonUtils;
import org.kie.kogito.event.job.JobInstanceDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDataEventDeserializer
implements Deserializer<JobInstanceDataEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobDataEventDeserializer.class);

    public JobInstanceDataEvent deserialize(String topic, byte[] data) {
        try {
            return (JobInstanceDataEvent)JsonUtils.getObjectMapper().readValue(new String(data), JobInstanceDataEvent.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("not possible to deserialize JobInstanceDataEvent data {}", (Object)new String(data), (Object)e);
            throw new IllegalArgumentException("not possible to deserialize data");
        }
    }
}

