/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kafka.common.serialization.Deserializer;
import org.kie.kogito.app.audit.json.JsonUtils;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceDataEventDeserializer
implements Deserializer<ProcessInstanceDataEvent<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceDataEventDeserializer.class);

    public ProcessInstanceDataEvent<?> deserialize(String topic, byte[] data) {
        try {
            return (ProcessInstanceDataEvent)JsonUtils.getObjectMapper().readValue(new String(data), ProcessInstanceDataEvent.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("not possible to deserialize ProcessInstanceDataEvent data {}", (Object)new String(data), (Object)e);
            throw new IllegalArgumentException("not possible to deserialize data");
        }
    }
}

