/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import org.kie.kogito.event.job.JobInstanceDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonJobDataEventDeserializer
extends StdDeserializer<JobInstanceDataEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonJobDataEventDeserializer.class);
    private static final long serialVersionUID = 6152014726577574241L;

    public JsonJobDataEventDeserializer() {
        this(null);
    }

    public JsonJobDataEventDeserializer(Class<?> vc) {
        super(vc);
    }

    public JobInstanceDataEvent deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        LOGGER.debug("Deserialize process instance data event: {}", (Object)node);
        JobInstanceDataEvent event = new JobInstanceDataEvent(node.has("type") ? node.get("type").asText() : null, node.has("source") ? node.get("source").asText() : null, node.has("data") ? node.get("data").binaryValue() : null, node.has("kogitoprocinstanceid") ? node.get("kogitoprocinstanceid").asText() : null, node.has("kogitorootprociid") ? node.get("kogitorootprociid").asText() : null, node.has("kogitoprocid") ? node.get("kogitoprocid").asText() : null, node.has("kogitorootprocid") ? node.get("kogitorootprocid").asText() : null, node.has("kogitoidentity") ? node.get("kogitoidentity").asText() : null);
        event.setId(node.has("id") ? node.get("id").asText() : null);
        event.setKogitoIdentity(node.has("kogitoidentity") ? node.get("kogitoidentity").asText() : null);
        event.setTime(node.has("time") ? (OffsetDateTime)jp.getCodec().treeToValue((TreeNode)node.get("time"), OffsetDateTime.class) : null);
        return event;
    }
}

