/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.quarkus;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.kie.kogito.event.job.JobInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceErrorDataEvent;
import org.kie.kogito.event.process.ProcessInstanceErrorEventBody;
import org.kie.kogito.event.process.ProcessInstanceNodeDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeEventBody;
import org.kie.kogito.event.process.ProcessInstanceStateDataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateEventBody;
import org.kie.kogito.event.process.ProcessInstanceVariableDataEvent;
import org.kie.kogito.event.process.ProcessInstanceVariableEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDeadlineDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDeadlineEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceStateDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableEventBody;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.ScheduledJob;

public class DataAuditTestUtils {
    public static final String ADDONS = "jobs-management,prometheus-monitoring,process-management";

    private static String toURIEndpoint(String processId) {
        return URI.create("http://localhost:8080/" + processId).toString();
    }

    public static String wrapQuery(String query) {
        return "{ \"query\" : \"" + query + " \"}";
    }

    public static JobInstanceDataEvent newJobEvent(String jobId, String nodeInstanceId, Integer priority, String processId, String procesInstanceId, Long repeatInterval, Integer repeatLimit, String rootProcessId, String rootProcessInstanceId, JobStatus state, Integer executionCounter) throws Exception {
        ScheduledJob job = new ScheduledJob();
        job.setId(jobId);
        job.setNodeInstanceId(nodeInstanceId);
        job.setCallbackEndpoint("https://callback");
        job.setPriority(priority);
        job.setProcessId(processId);
        job.setProcessInstanceId(procesInstanceId);
        job.setRepeatInterval(repeatInterval);
        job.setRepeatLimit(repeatLimit);
        job.setRootProcessId(rootProcessId);
        job.setRootProcessInstanceId(rootProcessInstanceId);
        job = ScheduledJob.builder().job((Job)job).status(state).executionCounter(executionCounter).scheduledId("my scheduler").expirationTime(ZonedDateTime.now()).build();
        JobInstanceDataEvent dataEvent = new JobInstanceDataEvent("JobEvent", DataAuditTestUtils.toURIEndpoint(processId), new ObjectMapper().registerModule((Module)new JavaTimeModule()).writeValueAsBytes((Object)job), procesInstanceId, rootProcessInstanceId, processId, rootProcessId, "identity");
        return dataEvent;
    }

    public static JobInstanceDataEvent deriveNewState(JobInstanceDataEvent jobEvent, Integer executionCounter, JobStatus state) throws Exception {
        ScheduledJob job = (ScheduledJob)new ObjectMapper().registerModule((Module)new JavaTimeModule()).readValue((byte[])jobEvent.getData(), ScheduledJob.class);
        job = ScheduledJob.builder().job((Job)job).status(state).executionCounter(executionCounter).scheduledId("my scheduler").expirationTime(ZonedDateTime.now()).build();
        JobInstanceDataEvent dataEvent = new JobInstanceDataEvent("JobEvent", jobEvent.getSource().toString(), new ObjectMapper().registerModule((Module)new JavaTimeModule()).writeValueAsBytes((Object)job), jobEvent.getKogitoProcessInstanceId(), jobEvent.getKogitoRootProcessInstanceId(), jobEvent.getKogitoProcessId(), jobEvent.getKogitoRootProcessId(), "identity");
        return dataEvent;
    }

    public static ProcessInstanceStateDataEvent newProcessInstanceStateEvent(String processId, String processInstanceId, Integer status, String rootProcessInstanceId, String rootProcessId, String parentProcessInstanceId, String identity, int eventType) {
        String processVersion = "1.0";
        String processType = "BPMN2";
        ProcessInstanceStateEventBody body = ProcessInstanceStateEventBody.create().processInstanceId(processInstanceId).parentInstanceId(parentProcessInstanceId).rootProcessInstanceId(rootProcessInstanceId).rootProcessId(rootProcessId).processId(processId).processType(processType).processVersion(processVersion).processName(UUID.randomUUID().toString()).eventDate(new Date()).state(status).businessKey("BusinessKey" + processInstanceId).roles(new String[]{"admin", "role2"}).eventUser(identity).eventType(Integer.valueOf(eventType)).build();
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("kogito.processinstance.id", processInstanceId);
        metadata.put("kogito.process.version", processVersion);
        metadata.put("kogito.process.id", processId);
        metadata.put("kogito.processinstance.state", String.valueOf(status));
        metadata.put("kogito.process.type", processType);
        metadata.put("kogito.processinstance.parentInstanceId", parentProcessInstanceId);
        metadata.put("kogito.processinstance.rootProcessId", rootProcessId);
        metadata.put("kogito.processinstance.rootInstanceId", rootProcessInstanceId);
        ProcessInstanceStateDataEvent event = new ProcessInstanceStateDataEvent(DataAuditTestUtils.toURIEndpoint(processId), ADDONS, identity, metadata, body);
        event.setKogitoBusinessKey(body.getBusinessKey());
        return event;
    }

    public static ProcessInstanceStateDataEvent deriveProcessInstanceStateEvent(ProcessInstanceStateDataEvent event, String identity, int status, int eventType) {
        ProcessInstanceStateEventBody body = ProcessInstanceStateEventBody.create().processInstanceId(((ProcessInstanceStateEventBody)event.getData()).getProcessInstanceId()).parentInstanceId(((ProcessInstanceStateEventBody)event.getData()).getParentInstanceId()).rootProcessInstanceId(((ProcessInstanceStateEventBody)event.getData()).getRootProcessInstanceId()).rootProcessId(((ProcessInstanceStateEventBody)event.getData()).getRootProcessId()).processId(((ProcessInstanceStateEventBody)event.getData()).getProcessId()).processType(((ProcessInstanceStateEventBody)event.getData()).getProcessType()).processVersion(((ProcessInstanceStateEventBody)event.getData()).getProcessVersion()).processName(((ProcessInstanceStateEventBody)event.getData()).getProcessName()).eventDate(new Date()).state(Integer.valueOf(status)).businessKey(((ProcessInstanceStateEventBody)event.getData()).getBusinessKey()).roles(new String[]{"admin"}).eventUser(identity).eventType(Integer.valueOf(eventType)).build();
        ProcessInstanceStateDataEvent newEvent = new ProcessInstanceStateDataEvent(DataAuditTestUtils.toURIEndpoint(body.getProcessId()), ADDONS, identity, DataAuditTestUtils.extractProcessInstnaceEventMetadata(event), body);
        newEvent.setKogitoBusinessKey(body.getBusinessKey());
        return newEvent;
    }

    public static ProcessInstanceNodeDataEvent newProcessInstanceNodeEvent(ProcessInstanceStateDataEvent pEvent, String nodeType, String nodeDefintionId, String nodeInstanceId, String nodeName, String connection, String identity, int eventType) {
        ProcessInstanceNodeEventBody body = ProcessInstanceNodeEventBody.create().processInstanceId(((ProcessInstanceStateEventBody)pEvent.getData()).getProcessInstanceId()).processId(((ProcessInstanceStateEventBody)pEvent.getData()).getProcessId()).processVersion(((ProcessInstanceStateEventBody)pEvent.getData()).getProcessVersion()).eventDate(new Date()).eventUser(identity).eventType(Integer.valueOf(eventType)).nodeName(nodeName).nodeType(nodeType).nodeDefinitionId(nodeDefintionId).nodeInstanceId(nodeInstanceId).connectionNodeDefinitionId(connection).build();
        ProcessInstanceNodeDataEvent event = new ProcessInstanceNodeDataEvent(DataAuditTestUtils.toURIEndpoint(body.getProcessId()), ADDONS, identity, DataAuditTestUtils.extractProcessInstnaceEventMetadata(pEvent), body);
        event.setKogitoBusinessKey(pEvent.getKogitoBusinessKey());
        return event;
    }

    public static ProcessInstanceVariableDataEvent newProcessInstanceVariableEvent(ProcessInstanceStateDataEvent pEvent, String variableId, String variableName, Object variableValue, String identity) {
        ProcessInstanceVariableEventBody body = ProcessInstanceVariableEventBody.create().eventDate(new Date()).eventUser(identity).processId(((ProcessInstanceStateEventBody)pEvent.getData()).getProcessId()).processVersion(((ProcessInstanceStateEventBody)pEvent.getData()).getProcessVersion()).processInstanceId(((ProcessInstanceStateEventBody)pEvent.getData()).getProcessInstanceId()).variableId(variableId).variableName(variableName).variableValue(variableValue).build();
        ProcessInstanceVariableDataEvent event = new ProcessInstanceVariableDataEvent(DataAuditTestUtils.toURIEndpoint(body.getProcessId()), ADDONS, identity, DataAuditTestUtils.extractProcessInstnaceEventMetadata(pEvent), body);
        event.setKogitoBusinessKey(pEvent.getKogitoBusinessKey());
        return event;
    }

    public static ProcessInstanceErrorDataEvent newProcessInstanceErrorEvent(ProcessInstanceStateDataEvent pEvent, String nodeDefintionId, String nodeInstanceId, String errorMessage, String identity) {
        ProcessInstanceErrorEventBody body = ProcessInstanceErrorEventBody.create().eventDate(new Date()).eventUser(identity).processId(((ProcessInstanceStateEventBody)pEvent.getData()).getProcessId()).processVersion(((ProcessInstanceStateEventBody)pEvent.getData()).getProcessVersion()).processInstanceId(((ProcessInstanceStateEventBody)pEvent.getData()).getProcessInstanceId()).nodeDefinitionId(nodeDefintionId).nodeInstanceId(nodeInstanceId).errorMessage(errorMessage).build();
        ProcessInstanceErrorDataEvent event = new ProcessInstanceErrorDataEvent(DataAuditTestUtils.toURIEndpoint(body.getProcessId()), ADDONS, identity, DataAuditTestUtils.extractProcessInstnaceEventMetadata(pEvent), body);
        event.setKogitoBusinessKey(pEvent.getKogitoBusinessKey());
        return event;
    }

    private static Map<String, Object> extractProcessInstnaceEventMetadata(ProcessInstanceDataEvent<?> pEvent) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("kogito.processinstance.id", pEvent.getKogitoProcessInstanceId());
        metadata.put("kogito.process.version", pEvent.getKogitoProcessInstanceVersion());
        metadata.put("kogito.process.id", pEvent.getKogitoProcessId());
        metadata.put("kogito.processinstance.state", pEvent.getKogitoProcessInstanceState());
        metadata.put("kogito.process.type", pEvent.getKogitoProcessType());
        metadata.put("kogito.processinstance.parentInstanceId", pEvent.getKogitoParentProcessInstanceId());
        metadata.put("kogito.processinstance.rootProcessId", pEvent.getKogitoRootProcessId());
        metadata.put("kogito.processinstance.rootInstanceId", pEvent.getKogitoRootProcessInstanceId());
        return metadata;
    }

    public static UserTaskInstanceStateDataEvent newUserTaskInstanceStateEvent(String eventUser, String userTaskDefinitionId, String userTaskInstanceId, String userTaskName, String eventType, String userTaskDescription, String userTaskPriority, String userTaskReferenceName, String state, String actualOwner, String processInstanceId) {
        String processId = UUID.randomUUID().toString();
        String processVersion = "1.0";
        String processType = "BPMN2";
        UserTaskInstanceStateEventBody body = UserTaskInstanceStateEventBody.create().eventUser(eventUser).eventDate(new Date()).userTaskDefinitionId(userTaskDefinitionId).userTaskInstanceId(userTaskInstanceId).userTaskName(userTaskName).eventType(eventType).userTaskDescription(userTaskDescription).userTaskDescription(userTaskPriority).userTaskReferenceName(userTaskReferenceName).state(state).actualOwner(actualOwner).processInstanceId(processInstanceId).build();
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("kogito.processinstance.id", processInstanceId);
        metadata.put("kogito.process.version", processVersion);
        metadata.put("kogito.process.id", processId);
        metadata.put("kogito.processinstance.state", String.valueOf(1));
        metadata.put("kogito.process.type", processType);
        metadata.put("kogito.processinstance.parentInstanceId", null);
        metadata.put("kogito.processinstance.rootProcessId", null);
        metadata.put("kogito.processinstance.rootInstanceId", null);
        metadata.put("kogito.usertaskinstance.id", userTaskInstanceId);
        metadata.put("kogito.usertaskinstance.state", state);
        UserTaskInstanceStateDataEvent event = new UserTaskInstanceStateDataEvent(DataAuditTestUtils.toURIEndpoint(processId), ADDONS, eventUser, metadata, body);
        event.setKogitoBusinessKey(UUID.randomUUID().toString());
        return event;
    }

    public static UserTaskInstanceVariableDataEvent newUserTaskInstanceVariableEvent(UserTaskInstanceStateDataEvent pEvent, String eventUser, String variableId, String variableName, String variableType, Object variableValue) {
        UserTaskInstanceVariableEventBody body = UserTaskInstanceVariableEventBody.create().eventUser(eventUser).eventDate(new Date()).userTaskDefinitionId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskDefinitionId()).userTaskInstanceId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskInstanceId()).userTaskName(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskName()).variableId(variableId).variableName(variableName).variableType(variableType).variableValue(variableValue).build();
        UserTaskInstanceVariableDataEvent event = new UserTaskInstanceVariableDataEvent(DataAuditTestUtils.toURIEndpoint(pEvent.getKogitoProcessId()), ADDONS, eventUser, DataAuditTestUtils.extractUserTaskInstnaceEventMetadata(pEvent), body);
        event.setKogitoBusinessKey(pEvent.getKogitoBusinessKey());
        return event;
    }

    public static UserTaskInstanceAssignmentDataEvent newUserTaskInstanceAssignmentEvent(UserTaskInstanceStateDataEvent pEvent, String eventUser, String assigmentType, String ... users) {
        UserTaskInstanceAssignmentEventBody body = UserTaskInstanceAssignmentEventBody.create().eventUser(eventUser).eventDate(new Date()).userTaskDefinitionId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskDefinitionId()).userTaskInstanceId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskInstanceId()).userTaskName(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskName()).assignmentType(assigmentType).users(users).build();
        UserTaskInstanceAssignmentDataEvent event = new UserTaskInstanceAssignmentDataEvent(DataAuditTestUtils.toURIEndpoint(pEvent.getKogitoProcessId()), ADDONS, eventUser, DataAuditTestUtils.extractUserTaskInstnaceEventMetadata(pEvent), body);
        event.setKogitoBusinessKey(pEvent.getKogitoBusinessKey());
        return event;
    }

    public static UserTaskInstanceAttachmentDataEvent newUserTaskInstanceAttachmentEvent(UserTaskInstanceStateDataEvent pEvent, String eventUser, String attachmentId, String attachmentName, URI attachmentURI, Integer eventType) {
        UserTaskInstanceAttachmentEventBody body = UserTaskInstanceAttachmentEventBody.create().eventUser(eventUser).eventDate(new Date()).userTaskDefinitionId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskDefinitionId()).userTaskInstanceId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskInstanceId()).userTaskName(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskName()).attachmentId(attachmentId).attachmentName(attachmentName).attachmentURI(attachmentURI).eventType(eventType.intValue()).build();
        UserTaskInstanceAttachmentDataEvent event = new UserTaskInstanceAttachmentDataEvent(DataAuditTestUtils.toURIEndpoint(pEvent.getKogitoProcessId()), ADDONS, eventUser, DataAuditTestUtils.extractUserTaskInstnaceEventMetadata(pEvent), body);
        event.setKogitoBusinessKey(pEvent.getKogitoBusinessKey());
        return event;
    }

    public static UserTaskInstanceDeadlineDataEvent newUserTaskInstanceDeadlineEvent(UserTaskInstanceStateDataEvent pEvent, String eventUser, Map<String, Object> inputs, Map<String, Object> notifications) {
        UserTaskInstanceDeadlineEventBody body = UserTaskInstanceDeadlineEventBody.create().eventUser(eventUser).eventDate(new Date()).userTaskDefinitionId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskDefinitionId()).userTaskInstanceId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskInstanceId()).userTaskName(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskName()).inputs(inputs).notification(notifications).build();
        UserTaskInstanceDeadlineDataEvent event = new UserTaskInstanceDeadlineDataEvent(DataAuditTestUtils.toURIEndpoint(pEvent.getKogitoProcessId()), ADDONS, eventUser, DataAuditTestUtils.extractUserTaskInstnaceEventMetadata(pEvent), body);
        event.setKogitoBusinessKey(pEvent.getKogitoBusinessKey());
        return event;
    }

    public static UserTaskInstanceCommentDataEvent newUserTaskInstanceCommentEvent(UserTaskInstanceStateDataEvent pEvent, String eventUser, String commentId, String commentContent, Integer eventType) {
        UserTaskInstanceCommentEventBody body = UserTaskInstanceCommentEventBody.create().eventUser(eventUser).eventDate(new Date()).userTaskDefinitionId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskDefinitionId()).userTaskInstanceId(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskInstanceId()).userTaskName(((UserTaskInstanceStateEventBody)pEvent.getData()).getUserTaskName()).commentId(commentId).commentContent(commentContent).eventType(eventType.intValue()).build();
        UserTaskInstanceCommentDataEvent event = new UserTaskInstanceCommentDataEvent(DataAuditTestUtils.toURIEndpoint(pEvent.getKogitoProcessId()), ADDONS, eventUser, DataAuditTestUtils.extractUserTaskInstnaceEventMetadata(pEvent), body);
        event.setKogitoBusinessKey(pEvent.getKogitoBusinessKey());
        return event;
    }

    private static Map<String, Object> extractUserTaskInstnaceEventMetadata(UserTaskInstanceDataEvent<?> pEvent) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("kogito.processinstance.id", pEvent.getKogitoProcessInstanceId());
        metadata.put("kogito.process.version", pEvent.getKogitoProcessInstanceVersion());
        metadata.put("kogito.process.id", pEvent.getKogitoProcessId());
        metadata.put("kogito.processinstance.state", pEvent.getKogitoProcessInstanceState());
        metadata.put("kogito.process.type", pEvent.getKogitoProcessType());
        metadata.put("kogito.processinstance.parentInstanceId", pEvent.getKogitoParentProcessInstanceId());
        metadata.put("kogito.processinstance.rootProcessId", pEvent.getKogitoRootProcessId());
        metadata.put("kogito.processinstance.rootInstanceId", pEvent.getKogitoRootProcessInstanceId());
        metadata.put("kogito.usertaskinstance.id", pEvent.getKogitoUserTaskInstanceId());
        metadata.put("kogito.usertaskinstance.state", pEvent.getKogitoUserTaskInstanceState());
        return metadata;
    }
}

