/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.api;

import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.kie.kogito.app.audit.api.DataAuditContext;
import org.kie.kogito.app.audit.api.DataAuditQuery;
import org.kie.kogito.app.audit.api.TypeCheck;
import org.kie.kogito.app.audit.spi.DataAuditStore;
import org.kie.kogito.event.job.JobInstanceDataEvent;
import org.kie.kogito.event.process.MultipleProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceErrorDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeDataEvent;
import org.kie.kogito.event.process.ProcessInstanceSLADataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateDataEvent;
import org.kie.kogito.event.process.ProcessInstanceVariableDataEvent;
import org.kie.kogito.event.usertask.MultipleUserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDeadlineDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAuditStoreProxyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAuditStoreProxyService.class);
    private DataAuditStore auditStoreService;

    private DataAuditStoreProxyService(DataAuditStore auditStoreService) {
        this.auditStoreService = auditStoreService;
    }

    public void storeProcessInstanceDataEvent(DataAuditContext context, ProcessInstanceDataEvent<?> event) {
        if (event instanceof MultipleProcessInstanceDataEvent) {
            ((Collection)((MultipleProcessInstanceDataEvent)event).getData()).forEach(e -> this.storeProcessInstanceDataEvent(context, (ProcessInstanceDataEvent<?>)e));
        } else {
            TypeCheck.typeCheckOf(ProcessInstanceErrorDataEvent.class).ifType(context, event, this.auditStoreService::storeProcessInstanceDataEvent);
            TypeCheck.typeCheckOf(ProcessInstanceNodeDataEvent.class).ifType(context, event, this.auditStoreService::storeProcessInstanceDataEvent);
            TypeCheck.typeCheckOf(ProcessInstanceSLADataEvent.class).ifType(context, event, this.auditStoreService::storeProcessInstanceDataEvent);
            TypeCheck.typeCheckOf(ProcessInstanceStateDataEvent.class).ifType(context, event, this.auditStoreService::storeProcessInstanceDataEvent);
            TypeCheck.typeCheckOf(ProcessInstanceVariableDataEvent.class).ifType(context, event, this.auditStoreService::storeProcessInstanceDataEvent);
        }
    }

    public void storeUserTaskInstanceDataEvent(DataAuditContext context, UserTaskInstanceDataEvent<?> event) {
        if (event instanceof MultipleUserTaskInstanceDataEvent) {
            ((Collection)((MultipleUserTaskInstanceDataEvent)event).getData()).forEach(e -> this.storeUserTaskInstanceDataEvent(context, (UserTaskInstanceDataEvent<?>)e));
        } else {
            TypeCheck.typeCheckOf(UserTaskInstanceAssignmentDataEvent.class).ifType(context, event, this.auditStoreService::storeUserTaskInstanceDataEvent);
            TypeCheck.typeCheckOf(UserTaskInstanceAttachmentDataEvent.class).ifType(context, event, this.auditStoreService::storeUserTaskInstanceDataEvent);
            TypeCheck.typeCheckOf(UserTaskInstanceCommentDataEvent.class).ifType(context, event, this.auditStoreService::storeUserTaskInstanceDataEvent);
            TypeCheck.typeCheckOf(UserTaskInstanceDeadlineDataEvent.class).ifType(context, event, this.auditStoreService::storeUserTaskInstanceDataEvent);
            TypeCheck.typeCheckOf(UserTaskInstanceStateDataEvent.class).ifType(context, event, this.auditStoreService::storeUserTaskInstanceDataEvent);
            TypeCheck.typeCheckOf(UserTaskInstanceVariableDataEvent.class).ifType(context, event, this.auditStoreService::storeUserTaskInstanceDataEvent);
        }
    }

    public void storeJobDataEvent(DataAuditContext context, JobInstanceDataEvent event) {
        this.auditStoreService.storeJobDataEvent(context, event);
    }

    public static DataAuditStoreProxyService newAuditStoreService() {
        DataAuditStore service = ServiceLoader.load(DataAuditStore.class).findFirst().orElseThrow(() -> new RuntimeException("DataAuditStore implementation not found"));
        LOGGER.debug("Creating new Data Audit Store proxy service with {}", (Object)service);
        return new DataAuditStoreProxyService(service);
    }

    public void storeQuery(DataAuditContext newDataAuditContext, DataAuditQuery dataAuditQuery) {
        LOGGER.info("Store query {}", (Object)dataAuditQuery);
        this.auditStoreService.storeQuery(newDataAuditContext, dataAuditQuery);
    }

    public List<DataAuditQuery> findQueries(DataAuditContext context) {
        return this.auditStoreService.findQueries(context);
    }
}

