/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app.audit.graphql;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.SchemaPrinter;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.kie.kogito.app.audit.api.DataAuditContext;
import org.kie.kogito.app.audit.api.DataAuditQuery;
import org.kie.kogito.app.audit.graphql.GraphQLSchemaBuild;
import org.kie.kogito.app.audit.spi.GraphQLSchemaQuery;
import org.kie.kogito.app.audit.spi.GraphQLSchemaQueryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaManager {
    private static final GraphQLSchemaManager INSTANCE = new GraphQLSchemaManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLSchemaManager.class);
    private GraphQLSchema graphQLSchema;
    private GraphQL graphQL;
    private Map<String, String> graphQLdefinitions = new HashMap<String, String>();

    public static GraphQLSchemaManager graphQLSchemaManagerInstance() {
        return INSTANCE;
    }

    private GraphQLSchemaManager() {
    }

    public GraphQLSchemaBuild rebuildDefinitions(DataAuditContext dataAuditContext, Map<String, String> additionalDefinitions) {
        LOGGER.debug("Rebuilding graphQL definitions");
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        runtimeWiringBuilder.scalar(ExtendedScalars.GraphQLBigInteger);
        runtimeWiringBuilder.scalar(ExtendedScalars.GraphQLLong);
        runtimeWiringBuilder.scalar(ExtendedScalars.Date);
        runtimeWiringBuilder.scalar(ExtendedScalars.DateTime);
        runtimeWiringBuilder.scalar(ExtendedScalars.Json);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
        TypeDefinitionRegistry typeDefinitionRegistry = new TypeDefinitionRegistry();
        ArrayList<String> graphqlSchemas = new ArrayList<String>();
        graphqlSchemas.addAll(List.of("META-INF/data-audit-types.graphqls", "META-INF/data-audit-job-query.graphqls", "META-INF/data-audit-process-query.graphqls", "META-INF/data-audit-usertask-query.graphqls"));
        ServiceLoader.load(GraphQLSchemaQueryProvider.class, classLoader).forEach(queryProvider -> {
            graphqlSchemas.addAll(List.of(queryProvider.graphQLQueryExtension()));
            for (GraphQLSchemaQuery query : queryProvider.queries(dataAuditContext)) {
                runtimeWiringBuilder.type("Query", builder -> builder.dataFetcher(query.name(), query::fetch));
            }
        });
        ArrayList<InputStream> data = new ArrayList<InputStream>();
        data.addAll(graphqlSchemas.stream().map(this::toInputStream).toList());
        data.addAll(additionalDefinitions.values().stream().map(String::getBytes).map(ByteArrayInputStream::new).toList());
        ArrayList queryDefinitions = new ArrayList();
        for (InputStream graphQLSchema : data) {
            TypeDefinitionRegistry newTypes = this.readDefinitionRegistry(graphQLSchema);
            Optional newDefinitions = newTypes.getType("Query", ObjectTypeDefinition.class);
            if (newDefinitions.isPresent()) {
                queryDefinitions.addAll(((ObjectTypeDefinition)newDefinitions.get()).getFieldDefinitions());
                newTypes.remove((SDLDefinition)newDefinitions.get());
            }
            typeDefinitionRegistry.merge(newTypes);
        }
        RuntimeWiring runtimeWiring = runtimeWiringBuilder.build();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        typeDefinitionRegistry.add((SDLDefinition)ObjectTypeDefinition.newObjectTypeDefinition().name("Query").fieldDefinitions(queryDefinitions).build());
        GraphQLSchema newGraphQLSchema = schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, runtimeWiring);
        GraphQL newGraphQL = GraphQL.newGraphQL((GraphQLSchema)newGraphQLSchema).build();
        LOGGER.debug("Succesfuly rebuilding graphQL definitions");
        return new GraphQLSchemaBuild(newGraphQLSchema, newGraphQL, additionalDefinitions);
    }

    private InputStream toInputStream(String classpathFile) {
        ByteArrayInputStream byteArrayInputStream;
        block8: {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFile);
            try {
                byteArrayInputStream = new ByteArrayInputStream(is.readAllBytes());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("could not find or process {}", (Object)this.graphQLSchema, (Object)e);
                    return new ByteArrayInputStream(new byte[0]);
                }
            }
            is.close();
        }
        return byteArrayInputStream;
    }

    private TypeDefinitionRegistry readDefinitionRegistry(InputStream inputStream) {
        SchemaParser schemaParser = new SchemaParser();
        return schemaParser.parse(inputStream);
    }

    public GraphQL getGraphQL() {
        return this.graphQL;
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    public ExecutionResult execute(ExecutionInput executionInput) {
        return this.graphQL.execute(executionInput);
    }

    public String getGraphQLSchemaDefinition() {
        SchemaPrinter printer = new SchemaPrinter();
        return printer.print(this.graphQL.getGraphQLSchema());
    }

    public void init(DataAuditContext dataAuditContext, Map<String, String> additionalQueries) {
        this.setGraphQLSchemaBuild(this.rebuildDefinitions(dataAuditContext, additionalQueries));
    }

    public GraphQLSchemaBuild devireNewDataAuditQuerySchema(DataAuditContext dataAuditContext, DataAuditQuery dataAuditQuery) {
        String graphQLDefinition = dataAuditQuery.getGraphQLDefinition();
        TypeDefinitionRegistry registry = this.readDefinitionRegistry(new ByteArrayInputStream(graphQLDefinition.getBytes()));
        LOGGER.debug("Registering data audit query {} with definition {}", (Object)dataAuditQuery.getIdentifier(), (Object)registry.getType("Query"));
        HashMap<String, String> additionalDefinitions = new HashMap<String, String>(this.graphQLdefinitions);
        additionalDefinitions.put(dataAuditQuery.getIdentifier(), dataAuditQuery.getGraphQLDefinition());
        return this.rebuildDefinitions(dataAuditContext, additionalDefinitions);
    }

    public void setGraphQLSchemaBuild(GraphQLSchemaBuild build) {
        this.graphQL = build.graphQL();
        this.graphQLSchema = build.graphQLSchema();
        this.graphQLdefinitions = build.additionalDefinitions();
    }
}

