/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.language.StringValue;
import graphql.schema.CoercingSerializeException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.graphql.DefaultDateTimeCoercing;

class DefaultDateTimeCoercingTest {
    DefaultDateTimeCoercing dateTimeCoercing = new DefaultDateTimeCoercing();

    DefaultDateTimeCoercingTest() {
    }

    @Test
    void testParseValueAsLong() {
        Assertions.assertThat((Object)this.dateTimeCoercing.parseValue(null)).isNull();
        Assertions.assertThat((Object)this.dateTimeCoercing.parseValue((Object)"2019-11-20T03:14:03.075Z")).isEqualTo((Object)ZonedDateTime.parse("2019-11-20T03:14:03.075Z").truncatedTo(ChronoUnit.MILLIS).toInstant().toEpochMilli());
        LocalDateTime testLocalDateTime = LocalDateTime.now();
        Assertions.assertThat((Object)this.dateTimeCoercing.parseValue((Object)testLocalDateTime.format(DateTimeFormatter.ISO_DATE_TIME))).isEqualTo((Object)testLocalDateTime.truncatedTo(ChronoUnit.MILLIS).toInstant(ZoneOffset.UTC).toEpochMilli());
    }

    @Test
    void testParseLiteral() {
        Assertions.assertThat((Object)this.dateTimeCoercing.parseLiteral(null)).isNull();
        Assertions.assertThat((Object)this.dateTimeCoercing.parseLiteral((Object)new StringValue("2019-11-20T03:14:03.075Z"))).isEqualTo((Object)1574219643075L);
        Assertions.assertThat((Object)this.dateTimeCoercing.parseLiteral((Object)new StringValue("2019-11-20T03:14:03.07"))).isEqualTo((Object)1574219643070L);
    }

    @Test
    void testSerializeNull() {
        try {
            this.dateTimeCoercing.serialize(null);
            Assertions.fail((String)"Method should throw CoercingSerializeException");
        }
        catch (CoercingSerializeException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Expected something we can convert to 'java.time.ZonedDateTime' but was 'null'.");
        }
    }

    @Test
    void testSerializeInvalidType() {
        try {
            this.dateTimeCoercing.serialize((Object)1);
            Assertions.fail((String)"Method should throw CoercingSerializeException");
        }
        catch (CoercingSerializeException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Expected something we can convert to 'java.time.ZonedDateTime' but was 'java.lang.Integer'.");
        }
    }

    @Test
    void testSerializeZonedDateTime() {
        ZonedDateTime time = ZonedDateTime.now().withZoneSameInstant(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS);
        String result = this.dateTimeCoercing.serialize((Object)time);
        Assertions.assertThat((String)result).isEqualTo(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(time));
    }

    @Test
    void testSerializeMillisAsString() {
        ZonedDateTime time = ZonedDateTime.now().withZoneSameInstant(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS);
        String result = this.dateTimeCoercing.serialize((Object)String.valueOf(time.toInstant().toEpochMilli()));
        Assertions.assertThat((String)result).isEqualTo(time.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
    }

    @Test
    void testSerializeInvalidString() {
        try {
            this.dateTimeCoercing.serialize((Object)"test");
            Assertions.fail((String)"Method should throw CoercingSerializeException");
        }
        catch (CoercingSerializeException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Invalid ISO-8601 value : 'test'. because of : 'Text 'test' could not be parsed at index 0'");
        }
    }

    @Test
    void testSerializeString() {
        String result = this.dateTimeCoercing.serialize((Object)"2019-08-20T19:26:02.092+00:00");
        Assertions.assertThat((String)result).isEqualTo("2019-08-20T19:26:02.092Z");
    }
}

