/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.graphql.JsonPropertyDataFetcher;
import org.mockito.Mockito;

class JsonPropertyDataFetcherTest {
    ObjectMapper objectMapper = new ObjectMapper();
    JsonPropertyDataFetcher jsonPropertyDataFetcher = new JsonPropertyDataFetcher();

    JsonPropertyDataFetcherTest() {
    }

    @Test
    void testBasicTypesDataFetcher() {
        JsonNode addressJson = this.createTestObjectNodeJson("city1", 8, true, null);
        Assertions.assertThat((Object)this.jsonPropertyDataFetcher.get(this.getMockEnv("city", addressJson))).isEqualTo((Object)"city1");
        Assertions.assertThat((Object)this.jsonPropertyDataFetcher.get(this.getMockEnv("amount", addressJson))).isEqualTo((Object)8);
        Assertions.assertThat((Object)this.jsonPropertyDataFetcher.get(this.getMockEnv("approved", addressJson))).isEqualTo((Object)true);
        Assertions.assertThat((Object)this.jsonPropertyDataFetcher.get(this.getMockEnv("zipCode", addressJson))).isNull();
    }

    @Test
    void testArraysTypesDataFetcher() {
        JsonNode arraysJson = this.getArraysNodeJson();
        Assertions.assertThat((int)((ArrayNode)this.jsonPropertyDataFetcher.get(this.getMockEnv("addressArray", arraysJson))).size()).isEqualTo(2);
        List stringArray = (List)this.jsonPropertyDataFetcher.get(this.getMockEnv("stringArray", arraysJson));
        Assertions.assertThat((List)stringArray).hasSize(2);
        Assertions.assertThat(stringArray.get(0)).isEqualTo((Object)"st1");
        Assertions.assertThat(stringArray.get(1)).isEqualTo((Object)"st2");
        List numberArray = (List)this.jsonPropertyDataFetcher.get(this.getMockEnv("numberArray", arraysJson));
        Assertions.assertThat((List)numberArray).hasSize(2);
        Assertions.assertThat(numberArray.get(0)).isEqualTo((Object)8);
        Assertions.assertThat(numberArray.get(1)).isEqualTo((Object)98.6);
        List booleanArray = (List)this.jsonPropertyDataFetcher.get(this.getMockEnv("booleanArray", arraysJson));
        Assertions.assertThat((List)booleanArray).hasSize(2);
        Assertions.assertThat(booleanArray.get(0)).isEqualTo((Object)true);
        Assertions.assertThat(booleanArray.get(1)).isEqualTo((Object)false);
    }

    private DataFetchingEnvironment getMockEnv(String fieldName, JsonNode jsonNode) {
        DataFetchingEnvironment env = (DataFetchingEnvironment)Mockito.mock(DataFetchingEnvironment.class);
        Field mockField = (Field)Mockito.mock(Field.class);
        Mockito.when((Object)mockField.getName()).thenReturn((Object)fieldName);
        Mockito.when((Object)env.getField()).thenReturn((Object)mockField);
        Mockito.when((Object)env.getSource()).thenReturn((Object)jsonNode);
        return env;
    }

    private JsonNode createTestObjectNodeJson(String city, Integer amount, Boolean approved, String zipCode) {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        objectNode.put("city", city);
        objectNode.put("amount", amount);
        objectNode.put("approved", approved);
        objectNode.put("zipCode", zipCode);
        return objectNode;
    }

    private JsonNode getArraysNodeJson() {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        ArrayNode addressesArrayNode = this.objectMapper.createArrayNode();
        addressesArrayNode.add(this.createTestObjectNodeJson("city1", 9, true, "zipCode1"));
        addressesArrayNode.add(this.createTestObjectNodeJson("city2", 97, false, "zipCode2"));
        ArrayNode stringArrayNode = this.objectMapper.createArrayNode();
        stringArrayNode.add("st1");
        stringArrayNode.add("st2");
        ArrayNode numberArrayNode = this.objectMapper.createArrayNode();
        numberArrayNode.add(8);
        numberArrayNode.add(98.6);
        ArrayNode booleanArrayNode = this.objectMapper.createArrayNode();
        booleanArrayNode.add(true);
        booleanArrayNode.add(false);
        objectNode.putIfAbsent("addressArray", (JsonNode)addressesArrayNode);
        objectNode.putIfAbsent("stringArray", (JsonNode)stringArrayNode);
        objectNode.putIfAbsent("numberArray", (JsonNode)numberArrayNode);
        objectNode.putIfAbsent("booleanArray", (JsonNode)booleanArrayNode);
        return objectNode;
    }
}

