/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.event.process.MilestoneEventBody;
import org.kie.kogito.event.process.NodeInstanceEventBody;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceEventBody;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;

public class ProcessInstanceEventMapper
implements Function<ProcessInstanceDataEvent, ProcessInstance> {
    @Override
    public ProcessInstance apply(ProcessInstanceDataEvent event) {
        if (event == null || event.getData() == null) {
            return null;
        }
        ProcessInstance pi = new ProcessInstance();
        pi.setId(((ProcessInstanceEventBody)event.getData()).getId());
        pi.setProcessId(((ProcessInstanceEventBody)event.getData()).getProcessId());
        pi.setProcessName(((ProcessInstanceEventBody)event.getData()).getProcessName());
        pi.setRootProcessInstanceId(((ProcessInstanceEventBody)event.getData()).getRootInstanceId());
        pi.setRootProcessId(((ProcessInstanceEventBody)event.getData()).getRootProcessId());
        pi.setParentProcessInstanceId(((ProcessInstanceEventBody)event.getData()).getParentInstanceId());
        pi.setRoles(((ProcessInstanceEventBody)event.getData()).getRoles());
        pi.setVariables((ObjectNode)JsonUtils.getObjectMapper().valueToTree((Object)((ProcessInstanceEventBody)event.getData()).getVariables()));
        pi.setNodes(((ProcessInstanceEventBody)event.getData()).getNodeInstances().stream().map(this.nodeInstance()).collect(Collectors.toList()));
        pi.setState(((ProcessInstanceEventBody)event.getData()).getState());
        pi.setStart(DateTimeUtils.toZonedDateTime(((ProcessInstanceEventBody)event.getData()).getStartDate()));
        pi.setEnd(DateTimeUtils.toZonedDateTime(((ProcessInstanceEventBody)event.getData()).getEndDate()));
        if (((ProcessInstanceEventBody)event.getData()).getError() != null) {
            pi.setError(new ProcessInstanceError(((ProcessInstanceEventBody)event.getData()).getError().getNodeDefinitionId(), ((ProcessInstanceEventBody)event.getData()).getError().getErrorMessage()));
        }
        pi.setMilestones(((ProcessInstanceEventBody)event.getData()).getMilestones().stream().map(this.milestone()).collect(Collectors.toList()));
        pi.setBusinessKey(((ProcessInstanceEventBody)event.getData()).getBusinessKey());
        pi.setAddons(Strings.isNullOrEmpty((String)event.getKogitoAddons()) ? null : Set.of(event.getKogitoAddons().split(",")));
        pi.setEndpoint(event.getSource() == null ? null : event.getSource().toString());
        pi.setLastUpdate(DateTimeUtils.toZonedDateTime(event.getTime()));
        pi.setVersion(((ProcessInstanceEventBody)event.getData()).getVersion());
        pi.setDefinition(this.definition().apply(event));
        return pi;
    }

    private Function<ProcessInstanceDataEvent, ProcessDefinition> definition() {
        return event -> {
            ProcessDefinition pd = new ProcessDefinition();
            pd.setId(((ProcessInstanceEventBody)event.getData()).getProcessId());
            pd.setName(((ProcessInstanceEventBody)event.getData()).getProcessName());
            pd.setVersion(((ProcessInstanceEventBody)event.getData()).getVersion());
            pd.setAddons(Strings.isNullOrEmpty((String)event.getKogitoAddons()) ? null : Set.of(event.getKogitoAddons().split(",")));
            pd.setRoles(((ProcessInstanceEventBody)event.getData()).getRoles());
            pd.setType(event.getKogitoProcessType());
            pd.setEndpoint(event.getSource() == null ? null : event.getSource().toString());
            return pd;
        };
    }

    private Function<NodeInstanceEventBody, NodeInstance> nodeInstance() {
        return nib -> {
            NodeInstance ni = new NodeInstance();
            ni.setId(nib.getId());
            ni.setEnter(DateTimeUtils.toZonedDateTime(nib.getTriggerTime()));
            ni.setName(nib.getNodeName());
            ni.setType(nib.getNodeType());
            ni.setNodeId(nib.getNodeId());
            ni.setDefinitionId(nib.getNodeDefinitionId());
            ni.setExit(DateTimeUtils.toZonedDateTime(nib.getLeaveTime()));
            return ni;
        };
    }

    private Function<MilestoneEventBody, Milestone> milestone() {
        return m -> Milestone.builder().id(m.getId()).name(m.getName()).status(m.getStatus()).build();
    }
}

