/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.event;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateDataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateEventBody;
import org.kie.kogito.index.json.JsonUtils;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class DataEventDeserializerTest {
    private ObjectMapper mapper;

    @BeforeAll
    public void beforeAll() {
        this.mapper = new ObjectMapper();
        JsonUtils.configure((ObjectMapper)this.mapper);
    }

    @Test
    public void testProcessInstanceDataEvent() throws IOException {
        ProcessInstanceStateDataEvent dataEvent = new ProcessInstanceStateDataEvent("source", "addons", "identity", new HashMap(), new ProcessInstanceStateEventBody());
        String jsonValue = this.mapper.writeValueAsString((Object)dataEvent);
        ProcessInstanceDataEvent readDataEvent = (ProcessInstanceDataEvent)this.mapper.readValue(jsonValue.getBytes(), ProcessInstanceDataEvent.class);
        Assertions.assertEquals((Object)readDataEvent, (Object)dataEvent);
    }

    @Test
    public void testUserTaskInstanceDataEvent() throws IOException {
        UserTaskInstanceStateDataEvent dataEvent = new UserTaskInstanceStateDataEvent("source", "addons", "identity", new HashMap(), new UserTaskInstanceStateEventBody());
        String jsonValue = this.mapper.writeValueAsString((Object)dataEvent);
        UserTaskInstanceDataEvent readDataEvent = (UserTaskInstanceDataEvent)this.mapper.readValue(jsonValue.getBytes(), UserTaskInstanceDataEvent.class);
        Assertions.assertEquals((Object)readDataEvent, (Object)dataEvent);
    }
}

