/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class JsonUtilsTest {
    @Test
    void testMergeWithDot() {
        ObjectNode expected = (ObjectNode)ObjectMapperFactory.get().createObjectNode().set("key", (JsonNode)ObjectMapperFactory.get().createObjectNode().put("user1", "manolo"));
        Assertions.assertThat((Iterable)JsonUtils.mergeVariable((String)"key.user1", (Object)"manolo", null)).isEqualTo((Object)expected);
    }

    @Test
    void testSimpleMerge() {
        ObjectNode expected = ObjectMapperFactory.get().createObjectNode().put("user1", "manolo");
        Assertions.assertThat((Iterable)JsonUtils.mergeVariable((String)"user1", (Object)"manolo", null)).isEqualTo((Object)expected);
    }

    @Test
    void testComplexMergeWithDot() {
        ObjectNode expected = (ObjectNode)ObjectMapperFactory.get().createObjectNode().set("key", (JsonNode)ObjectMapperFactory.get().createObjectNode().put("user1", "manolo").put("user2", "pepe"));
        Assertions.assertThat((Iterable)JsonUtils.mergeVariable((String)"key.user1", (Object)"manolo", (ObjectNode)((ObjectNode)ObjectMapperFactory.get().createObjectNode().set("key", (JsonNode)ObjectMapperFactory.get().createObjectNode().put("user2", "pepe"))))).isEqualTo((Object)expected);
    }
}

